/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.PathUtils;

public class PublicKeyEntry
implements Serializable,
KeyTypeIndicator {
    public static final char COMMENT_CHAR = '#';
    public static final String STD_KEYFILE_FOLDER_NAME = ".ssh";
    public static final String PUBKEY_FILE_SUFFIX = ".pub";
    private static final long serialVersionUID = -585506072687602760L;
    private static final NavigableMap<String, PublicKeyEntryDataResolver> KEY_DATA_RESOLVERS = new TreeMap<String, PublicKeyEntryDataResolver>(String.CASE_INSENSITIVE_ORDER);
    private String keyType;
    private byte[] keyData;
    private PublicKeyEntryDataResolver keyDataResolver = PublicKeyEntryDataResolver.DEFAULT;

    public PublicKeyEntry() {
    }

    public PublicKeyEntry(String keyType, byte ... keyData) {
        this.keyType = keyType;
        this.keyData = keyData;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String value2) {
        this.keyType = value2;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public void setKeyData(byte[] value2) {
        this.keyData = value2;
    }

    public PublicKeyEntryDataResolver getKeyDataResolver() {
        return this.keyDataResolver;
    }

    public void setKeyDataResolver(PublicKeyEntryDataResolver keyDataResolver) {
        this.keyDataResolver = keyDataResolver;
    }

    public PublicKeyEntryDataResolver resolvePublicKeyEntryDataResolver() {
        PublicKeyEntryDataResolver resolver = this.getKeyDataResolver();
        return resolver == null ? PublicKeyEntryDataResolver.DEFAULT : resolver;
    }

    public PublicKey resolvePublicKey(SessionContext session2, Map<String, String> headers2, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        String kt = this.getKeyType();
        PublicKeyEntryResolver decoder = KeyUtils.getPublicKeyEntryDecoder(kt);
        if (decoder == null) {
            decoder = fallbackResolver;
        }
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder available for key type=" + kt);
        }
        return decoder.resolve(session2, kt, this.getKeyData(), headers2);
    }

    public PublicKey appendPublicKey(SessionContext session2, Appendable sb, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        PublicKey key2 = this.resolvePublicKey(session2, Collections.emptyMap(), fallbackResolver);
        if (key2 != null) {
            PublicKeyEntry.appendPublicKeyEntry(sb, key2, this.resolvePublicKeyEntryDataResolver());
        }
        return key2;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKeyType()) + Arrays.hashCode(this.getKeyData());
    }

    protected boolean isEquivalent(PublicKeyEntry e2) {
        if (this == e2) {
            return true;
        }
        return Objects.equals(this.getKeyType(), e2.getKeyType()) && Arrays.equals(this.getKeyData(), e2.getKeyData());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEquivalent((PublicKeyEntry)obj);
    }

    public String toString() {
        PublicKeyEntryDataResolver resolver = this.resolvePublicKeyEntryDataResolver();
        String encData = resolver.encodeEntryKeyData(this.getKeyData());
        return this.getKeyType() + " " + (GenericUtils.isEmpty(encData) ? "<no-key>" : encData);
    }

    public static List<PublicKey> resolvePublicKeyEntries(SessionContext session2, Collection<? extends PublicKeyEntry> entries2, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        int numEntries = GenericUtils.size(entries2);
        if (numEntries <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys2 = new ArrayList<PublicKey>(numEntries);
        Iterator<? extends PublicKeyEntry> iterator2 = entries2.iterator();
        while (iterator2.hasNext()) {
            PublicKeyEntry e2;
            Map<String, String> headers2 = (e2 = iterator2.next()) instanceof AuthorizedKeyEntry ? ((AuthorizedKeyEntry)e2).getLoginOptions() : Collections.emptyMap();
            PublicKey k2 = e2.resolvePublicKey(session2, headers2, fallbackResolver);
            if (k2 == null) continue;
            keys2.add(k2);
        }
        return keys2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerKeyDataEntryResolver(String keyType, PublicKeyEntryDataResolver resolver) {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        Objects.requireNonNull(resolver, "No resolver provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            KEY_DATA_RESOLVERS.put(keyType, resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver getKeyDataEntryResolver(String keyType) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.get(keyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver unregisterKeyDataEntryResolver(String keyType) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.remove(keyType);
        }
    }

    public static PublicKeyEntryDataResolver resolveKeyDataEntryResolver(String keyType) {
        PublicKeyEntryDataResolver resolver = PublicKeyEntry.getKeyDataEntryResolver(keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided"));
        if (resolver != null) {
            return resolver;
        }
        return PublicKeyEntryDataResolver.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableMap<String, PublicKeyEntryDataResolver> getRegisteredKeyDataEntryResolvers() {
        TreeMap<String, PublicKeyEntryDataResolver> decoders;
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            if (KEY_DATA_RESOLVERS.isEmpty()) {
                return Collections.emptyNavigableMap();
            }
            decoders = new TreeMap<String, PublicKeyEntryDataResolver>(KEY_DATA_RESOLVERS.comparator());
            decoders.putAll(KEY_DATA_RESOLVERS);
        }
        return decoders;
    }

    public static PublicKeyEntry parsePublicKeyEntry(String encData) throws IllegalArgumentException {
        return PublicKeyEntry.parsePublicKeyEntry(encData, (PublicKeyEntryDataResolver)null);
    }

    public static PublicKeyEntry parsePublicKeyEntry(String encData, PublicKeyEntryDataResolver decoder) throws IllegalArgumentException {
        String data2 = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data2)) {
            return null;
        }
        return PublicKeyEntry.parsePublicKeyEntry(new PublicKeyEntry(), data2, decoder);
    }

    public static <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String encData) throws IllegalArgumentException {
        return PublicKeyEntry.parsePublicKeyEntry(entry, encData, null);
    }

    public static <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String encData, PublicKeyEntryDataResolver decoder) throws IllegalArgumentException {
        String b64Data;
        byte[] keyData;
        String data2 = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data2) || entry == null) {
            return entry;
        }
        int startPos = data2.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + data2);
        }
        int endPos = data2.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = data2.length();
        }
        String keyType = data2.substring(0, startPos);
        if (decoder == null) {
            decoder = PublicKeyEntry.resolveKeyDataEntryResolver(keyType);
        }
        if (NumberUtils.isEmpty(keyData = decoder.decodeEntryKeyData(b64Data = data2.substring(startPos + 1, endPos).trim()))) {
            throw new IllegalArgumentException("Bad format (no BASE64 key data): " + data2);
        }
        entry.setKeyType(keyType);
        entry.setKeyDataResolver(decoder);
        entry.setKeyData(keyData);
        return entry;
    }

    public static String toString(PublicKey key2) throws IllegalArgumentException {
        return PublicKeyEntry.toString(key2, null);
    }

    public static String toString(PublicKey key2, PublicKeyEntryDataResolver encoder2) throws IllegalArgumentException {
        try {
            return PublicKeyEntry.appendPublicKeyEntry(new StringBuilder(127), key2, encoder2).toString();
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Failed (" + e2.getClass().getSimpleName() + ") to encode: " + e2.getMessage(), e2);
        }
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key2) throws IOException {
        return PublicKeyEntry.appendPublicKeyEntry(sb, key2, null);
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key2, PublicKeyEntryDataResolver encoder2) throws IOException {
        byte[] bytes;
        String keyType;
        if (key2 == null) {
            return sb;
        }
        if (key2 instanceof UnsupportedSshPublicKey) {
            UnsupportedSshPublicKey unsupported = (UnsupportedSshPublicKey)key2;
            keyType = unsupported.getKeyType();
            bytes = unsupported.getKeyData();
        } else {
            PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(key2);
            if (decoder == null) {
                throw new StreamCorruptedException("Cannot retrieve decoder for key=" + key2.getAlgorithm());
            }
            try (ByteArrayOutputStream s2 = new ByteArrayOutputStream(127);){
                keyType = decoder.encodePublicKey(s2, key2);
                bytes = s2.toByteArray();
            }
        }
        if (encoder2 == null) {
            encoder2 = PublicKeyEntry.resolveKeyDataEntryResolver(keyType);
        }
        String encData = encoder2.encodeEntryKeyData(bytes);
        sb.append(keyType).append(' ').append(encData);
        return sb;
    }

    public static Path getDefaultKeysFolderPath() {
        return LazyDefaultKeysFolderHolder.PATH;
    }

    private static final class LazyDefaultKeysFolderHolder {
        private static final Path PATH = PathUtils.getUserHomeFolder().resolve(".ssh");

        private LazyDefaultKeysFolderHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

