/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.URLResource;

public interface PublicKeyRawDataReader<PUB extends PublicKey> {
    default public PUB readPublicKey(SessionContext session2, Path path2, OpenOption ... options2) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, path2, StandardCharsets.UTF_8, options2);
    }

    default public PUB readPublicKey(SessionContext session2, Path path2, Charset cs, OpenOption ... options2) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, new PathResource(path2, options2), cs);
    }

    default public PUB readPublicKey(SessionContext session2, URL url2) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, url2, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session2, URL url2, Charset cs) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, new URLResource(url2), cs);
    }

    default public PUB readPublicKey(SessionContext session2, IoResource<?> resource2) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, resource2, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session2, IoResource<?> resource2, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStream stream = Objects.requireNonNull(resource2, "No resource data").openInputStream();){
            PUB PUB = this.readPublicKey(session2, resource2, stream, cs);
            return PUB;
        }
    }

    default public PUB readPublicKey(SessionContext session2, NamedResource resourceKey, InputStream stream) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session2, resourceKey, stream, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session2, NamedResource resourceKey, InputStream stream, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStreamReader reader2 = new InputStreamReader(Objects.requireNonNull(stream, "No stream instance"), Objects.requireNonNull(cs, "No charset"));){
            PUB PUB = this.readPublicKey(session2, resourceKey, reader2);
            return PUB;
        }
    }

    default public PUB readPublicKey(SessionContext session2, NamedResource resourceKey, Reader rdr) throws IOException, GeneralSecurityException {
        try (BufferedReader br = new BufferedReader(Objects.requireNonNull(rdr, "No reader instance"), 8192);){
            PUB PUB = this.readPublicKey(session2, resourceKey, br);
            return PUB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public PUB readPublicKey(SessionContext session2, NamedResource resourceKey, BufferedReader rdr) throws IOException, GeneralSecurityException {
        List<String> lines = IoUtils.readAllLines(rdr);
        try {
            PUB PUB = this.readPublicKey(session2, resourceKey, lines);
            return PUB;
        }
        finally {
            lines.clear();
        }
    }

    public PUB readPublicKey(SessionContext var1, NamedResource var2, List<String> var3) throws IOException, GeneralSecurityException;
}

