/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.AbstractKeyEntryResolver;
import org.apache.sshd.common.util.MapEntryUtils;

public abstract class AbstractPublicKeyEntryDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractKeyEntryResolver<PUB, PRV>
implements PublicKeyEntryDecoder<PUB, PRV> {
    protected AbstractPublicKeyEntryDecoder(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names2) {
        super(pubType, prvType, names2);
    }

    protected final boolean parseBooleanHeader(Map<String, String> headers2, String propertyKey, boolean defaultVal) {
        Boolean boolVal;
        if (MapEntryUtils.isEmpty(headers2) || !headers2.containsKey(propertyKey)) {
            return defaultVal;
        }
        String stringVal = headers2.get(propertyKey);
        try {
            boolVal = PropertyResolverUtils.parseBoolean(stringVal);
        }
        catch (IllegalArgumentException e2) {
            this.log.warn("Ignoring non-boolean property value for \"{}\": {}", (Object)propertyKey, (Object)stringVal);
            boolVal = null;
        }
        if (boolVal == null) {
            return defaultVal;
        }
        return boolVal;
    }
}

