/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder<ECPublicKey, ECPrivateKey> {
    public static final int MAX_ALLOWED_POINT_SIZE = Short.MAX_VALUE;
    public static final int MAX_CURVE_NAME_LENGTH = 1024;
    public static final ECDSAPublicKeyEntryDecoder INSTANCE = new ECDSAPublicKeyEntryDecoder();
    public static final byte ECPOINT_UNCOMPRESSED_FORM_INDICATOR = 4;
    public static final byte ECPOINT_COMPRESSED_VARIANT_2 = 2;
    public static final byte ECPOINT_COMPRESSED_VARIANT_3 = 2;

    public ECDSAPublicKeyEntryDecoder() {
        super(ECPublicKey.class, ECPrivateKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public ECPublicKey decodePublicKey(SessionContext session2, String keyType, InputStream keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        ECCurves curve = ECCurves.fromKeyType(keyType);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + keyType);
        }
        return this.decodePublicKey(curve, keyData);
    }

    ECPublicKey decodePublicKey(ECCurves curve, InputStream keyData) throws IOException, GeneralSecurityException {
        ECPoint w;
        String encCurveName;
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        String keyCurveName = curve.getName();
        if (!keyCurveName.equals(encCurveName = KeyEntryResolver.decodeString(keyData, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + keyCurveName + ") vs. encoded one (" + encCurveName + ")");
        }
        byte[] octets = KeyEntryResolver.readRLEBytes(keyData, Short.MAX_VALUE);
        try {
            w = ECCurves.octetStringToEcPoint(octets);
            if (w == null) {
                throw new InvalidKeySpecException("No ECPoint generated for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex(':', octets));
            }
        }
        catch (RuntimeException e2) {
            throw new InvalidKeySpecException("Failed (" + e2.getClass().getSimpleName() + ") to generate ECPoint for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex(':', octets) + ": " + e2.getMessage());
        }
        ECParameterSpec paramSpec = curve.getParameters();
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(w, paramSpec));
    }

    @Override
    public ECPublicKey clonePublicKey(ECPublicKey key2) throws GeneralSecurityException {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (key2 == null) {
            return null;
        }
        ECParameterSpec params = key2.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(key2.getW(), params));
    }

    @Override
    public ECPrivateKey clonePrivateKey(ECPrivateKey key2) throws GeneralSecurityException {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (key2 == null) {
            return null;
        }
        ECParameterSpec params = key2.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(key2.getS(), params));
    }

    @Override
    public String encodePublicKey(OutputStream s2, ECPublicKey key2) throws IOException {
        Objects.requireNonNull(key2, "No public key provided");
        ECParameterSpec params = Objects.requireNonNull(key2.getParams(), "No EC parameters available");
        ECCurves curve = Objects.requireNonNull(ECCurves.fromCurveParameters(params), "Cannot determine curve");
        String keyType = curve.getKeyType();
        ECDSAPublicKeyEntryDecoder.encodePublicKey(s2, keyType, curve, key2.getW());
        return keyType;
    }

    static void encodePublicKey(OutputStream s2, String keyType, ECCurves curve, ECPoint w) throws IOException {
        String curveName = curve.getName();
        KeyEntryResolver.encodeString(s2, keyType);
        KeyEntryResolver.encodeString(s2, curveName);
        ECCurves.ECPointCompression.UNCOMPRESSED.writeECPoint(s2, curveName, w);
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyFactory("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        ECCurves curve = ECCurves.fromCurveSize(keySize);
        if (curve == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + keySize);
        }
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(curve.getParameters());
        return gen.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyPairGenerator("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }
}

