/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.OpenSSHCertPublicKeyParser;
import org.apache.sshd.common.util.io.IoUtils;

public class OpenSSHCertificateDecoder
extends AbstractPublicKeyEntryDecoder<OpenSshCertificate, OpenSshCertificate> {
    public static final OpenSSHCertificateDecoder INSTANCE = new OpenSSHCertificateDecoder();

    public OpenSSHCertificateDecoder() {
        super(OpenSshCertificate.class, OpenSshCertificate.class, Collections.unmodifiableList(Arrays.asList("rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-512-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com", "ssh-dss-cert-v01@openssh.com", "ssh-ed25519-cert-v01@openssh.com", "ecdsa-sha2-nistp256-cert-v01@openssh.com", "ecdsa-sha2-nistp384-cert-v01@openssh.com", "ecdsa-sha2-nistp521-cert-v01@openssh.com")));
    }

    @Override
    public OpenSshCertificate decodePublicKey(SessionContext session2, String keyType, InputStream keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(keyType);
        buffer.putRawBytes(IoUtils.toByteArray(keyData));
        buffer.getString();
        OpenSshCertificate cert = OpenSSHCertPublicKeyParser.INSTANCE.getRawPublicKey(keyType, buffer);
        return cert;
    }

    @Override
    public String encodePublicKey(OutputStream s2, OpenSshCertificate key2) throws IOException {
        Objects.requireNonNull(key2, "No public key provided");
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(key2);
        s2.write(buffer.getCompactData());
        return key2.getKeyType();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenSshCertificate clonePublicKey(OpenSshCertificate key2) throws GeneralSecurityException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            PublicKey publicKey;
            String keyType = this.encodePublicKey((OutputStream)outStream, key2);
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());){
                publicKey = this.decodePublicKey((SessionContext)null, keyType, (InputStream)inStream, (Map)null);
            }
            return publicKey;
        }
        catch (IOException e2) {
            throw new GeneralSecurityException("Unable to clone key ID=" + key2.getId(), e2);
        }
    }

    @Override
    public OpenSshCertificate clonePrivateKey(OpenSshCertificate key2) throws GeneralSecurityException {
        return this.clonePublicKey(key2);
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return null;
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return null;
    }
}

