/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.util.security.SecurityUtils;

public class AESPrivateKeyObfuscator
extends AbstractPrivateKeyObfuscator {
    public static final String CIPHER_NAME = "AES";
    public static final AESPrivateKeyObfuscator INSTANCE = new AESPrivateKeyObfuscator();

    public AESPrivateKeyObfuscator() {
        super(CIPHER_NAME);
    }

    @Override
    public List<Integer> getSupportedKeySizes() {
        return AESPrivateKeyObfuscator.getAvailableKeyLengths();
    }

    @Override
    public byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, boolean encryptIt) throws GeneralSecurityException, IOException {
        int keyLength = this.resolveKeyLength(encContext);
        byte[] keyValue = this.deriveEncryptionKey(encContext, keyLength / 8);
        return this.applyPrivateKeyCipher(bytes, encContext, keyLength, keyValue, encryptIt);
    }

    @Override
    protected int resolveInitializationVectorLength(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        int keyLength = this.resolveKeyLength(encContext);
        CipherInformation ci = this.resolveCipherInformation(keyLength, encContext.getCipherMode());
        if (ci == null) {
            throw new NoSuchAlgorithmException("No match found for " + encContext);
        }
        return ci.getIVSize();
    }

    protected CipherInformation resolveCipherInformation(int keyLength, String cipherMode) {
        Predicate<CipherInformation> selector = AESPrivateKeyObfuscator.createCipherSelector(keyLength, cipherMode);
        return BuiltinCiphers.VALUES.stream().filter(selector).findFirst().orElse(null);
    }

    @Override
    protected int resolveKeyLength(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        String cipherType = encContext.getCipherType();
        try {
            int keyLength = Integer.parseInt(cipherType);
            List<Integer> sizes = this.getSupportedKeySizes();
            for (Integer s2 : sizes) {
                if (s2 != keyLength) continue;
                return keyLength;
            }
            throw new InvalidKeySpecException("Unknown " + this.getCipherName() + " key length: " + cipherType + " - supported: " + sizes);
        }
        catch (NumberFormatException e2) {
            throw new InvalidKeySpecException("Bad " + this.getCipherName() + " key length (" + cipherType + "): " + e2.getMessage(), e2);
        }
    }

    public static List<Integer> getAvailableKeyLengths() {
        return LazyKeyLengthsHolder.KEY_LENGTHS;
    }

    public static Predicate<CipherInformation> createCipherSelector(int keyLength, String cipherMode) {
        String xformMode = "/" + cipherMode.toUpperCase() + "/";
        return c2 -> CIPHER_NAME.equalsIgnoreCase(c2.getAlgorithm()) && keyLength == c2.getKeySize() && c2.getTransformation().contains(xformMode);
    }

    private static final class LazyKeyLengthsHolder {
        private static final List<Integer> KEY_LENGTHS = Collections.unmodifiableList(LazyKeyLengthsHolder.detectSupportedKeySizes());

        private LazyKeyLengthsHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        private static List<Integer> detectSupportedKeySizes() {
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            for (int keyLength = 128; keyLength < Short.MAX_VALUE; keyLength += 64) {
                try {
                    byte[] keyAsBytes = new byte[keyLength / 8];
                    SecretKeySpec key2 = new SecretKeySpec(keyAsBytes, AESPrivateKeyObfuscator.CIPHER_NAME);
                    Cipher c2 = SecurityUtils.getCipher(AESPrivateKeyObfuscator.CIPHER_NAME);
                    c2.init(2, key2);
                    sizes.add(keyLength);
                    continue;
                }
                catch (GeneralSecurityException e2) {
                    return sizes;
                }
            }
            throw new IllegalStateException("No limit encountered: " + sizes);
        }
    }
}

