/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairResourceParser
extends KeyPairResourceLoader {
    public static final KeyPairResourceParser EMPTY = new KeyPairResourceParser(){

        @Override
        public Collection<KeyPair> loadKeyPairs(SessionContext session2, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
            return Collections.emptyList();
        }

        @Override
        public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
            return false;
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public boolean canExtractKeyPairs(NamedResource var1, List<String> var2) throws IOException, GeneralSecurityException;

    public static byte[] extractDataBytes(Collection<String> lines) {
        String data2 = KeyPairResourceParser.joinDataLines(lines);
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(data2);
    }

    public static String joinDataLines(Collection<String> lines) {
        String data2 = GenericUtils.join(lines, ' ');
        data2 = data2.replaceAll("\\s", "");
        data2 = data2.trim();
        return data2;
    }

    public static boolean containsMarkerLine(List<String> lines, String marker) {
        return KeyPairResourceParser.containsMarkerLine(lines, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(marker, "No marker")));
    }

    public static boolean containsMarkerLine(List<String> lines, List<String> markers) {
        return KeyPairResourceParser.findMarkerLine(lines, markers) != null;
    }

    public static AbstractMap.SimpleImmutableEntry<Integer, Integer> findMarkerLine(List<String> lines, List<String> markers) {
        return KeyPairResourceParser.findMarkerLine(lines, 0, markers);
    }

    public static AbstractMap.SimpleImmutableEntry<Integer, Integer> findMarkerLine(List<String> lines, int startLine, List<String> markers) {
        if (GenericUtils.isEmpty(lines) || GenericUtils.isEmpty(markers)) {
            return null;
        }
        for (int lineIndex = startLine; lineIndex < lines.size(); ++lineIndex) {
            String l = lines.get(lineIndex);
            for (int markerIndex = 0; markerIndex < markers.size(); ++markerIndex) {
                String m4 = markers.get(markerIndex);
                if (!l.contains(m4)) continue;
                return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(lineIndex, markerIndex);
            }
        }
        return null;
    }

    public static KeyPairResourceParser aggregate(KeyPairResourceParser ... parsers) {
        return KeyPairResourceParser.aggregate(Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty(parsers, "No parsers to aggregate", new Object[0])));
    }

    public static KeyPairResourceParser aggregate(final Collection<? extends KeyPairResourceParser> parsers) {
        ValidateUtils.checkNotNullAndNotEmpty(parsers, "No parsers to aggregate", new Object[0]);
        return new KeyPairResourceParser(){

            @Override
            public Collection<KeyPair> loadKeyPairs(SessionContext session2, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
                List<KeyPair> keyPairs = Collections.emptyList();
                for (KeyPairResourceParser p : parsers) {
                    Collection<KeyPair> kps;
                    if (!p.canExtractKeyPairs(resourceKey, lines) || GenericUtils.isEmpty(kps = p.loadKeyPairs(session2, resourceKey, passwordProvider, lines))) continue;
                    if (GenericUtils.isEmpty(keyPairs)) {
                        keyPairs = new LinkedList<KeyPair>(kps);
                        continue;
                    }
                    keyPairs.addAll(kps);
                }
                return keyPairs;
            }

            @Override
            public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
                for (KeyPairResourceParser p : parsers) {
                    if (!p.canExtractKeyPairs(resourceKey, lines)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return KeyPairResourceParser.class.getSimpleName() + "[aggregate]";
            }
        };
    }
}

