/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.auth.MutablePassword;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.DESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class PrivateKeyEncryptionContext
implements MutablePassword,
Cloneable {
    public static final String DEFAULT_CIPHER_MODE = "CBC";
    private static final Map<String, PrivateKeyObfuscator> OBFUSCATORS = Stream.of(AESPrivateKeyObfuscator.INSTANCE, DESPrivateKeyObfuscator.INSTANCE).collect(Collectors.toMap(AbstractPrivateKeyObfuscator::getCipherName, Function.identity(), MapEntryUtils.throwingMerger(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    private String cipherName;
    private String cipherType;
    private String cipherMode = "CBC";
    private String password;
    private byte[] initVector;
    private transient PrivateKeyObfuscator obfuscator;

    public PrivateKeyEncryptionContext() {
    }

    public PrivateKeyEncryptionContext(String algInfo) {
        this.parseAlgorithmInfo(algInfo);
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String value2) {
        this.cipherName = value2;
    }

    public String getCipherType() {
        return this.cipherType;
    }

    public void setCipherType(String value2) {
        this.cipherType = value2;
    }

    public String getCipherMode() {
        return this.cipherMode;
    }

    public void setCipherMode(String value2) {
        this.cipherMode = value2;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String value2) {
        this.password = value2;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public void setInitVector(byte ... values2) {
        this.initVector = values2;
    }

    public PrivateKeyObfuscator getPrivateKeyObfuscator() {
        return this.obfuscator;
    }

    public void setPrivateKeyObfuscator(PrivateKeyObfuscator value2) {
        this.obfuscator = value2;
    }

    public PrivateKeyObfuscator resolvePrivateKeyObfuscator() {
        PrivateKeyObfuscator value2 = this.getPrivateKeyObfuscator();
        if (value2 != null) {
            return value2;
        }
        return PrivateKeyEncryptionContext.getRegisteredPrivateKeyObfuscator(this.getCipherName());
    }

    public static PrivateKeyObfuscator registerPrivateKeyObfuscator(PrivateKeyObfuscator o) {
        return PrivateKeyEncryptionContext.registerPrivateKeyObfuscator(Objects.requireNonNull(o, "No instance provided").getCipherName(), o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyObfuscator registerPrivateKeyObfuscator(String cipherName, PrivateKeyObfuscator o) {
        ValidateUtils.checkNotNullAndNotEmpty(cipherName, "No cipher name");
        Objects.requireNonNull(o, "No instance provided");
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            return OBFUSCATORS.put(cipherName, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterPrivateKeyObfuscator(PrivateKeyObfuscator o) {
        Objects.requireNonNull(o, "No instance provided");
        String cipherName = o.getCipherName();
        ValidateUtils.checkNotNullAndNotEmpty(cipherName, "No cipher name");
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            PrivateKeyObfuscator prev = OBFUSCATORS.get(cipherName);
            if (prev != o) {
                return false;
            }
            OBFUSCATORS.remove(cipherName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyObfuscator unregisterPrivateKeyObfuscator(String cipherName) {
        ValidateUtils.checkNotNullAndNotEmpty(cipherName, "No cipher name");
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            return OBFUSCATORS.remove(cipherName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PrivateKeyObfuscator getRegisteredPrivateKeyObfuscator(String cipherName) {
        if (GenericUtils.isEmpty(cipherName)) {
            return null;
        }
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            return OBFUSCATORS.get(cipherName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NavigableSet<String> getRegisteredPrivateKeyObfuscatorCiphers() {
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            Set<String> names2 = OBFUSCATORS.keySet();
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, names2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<PrivateKeyObfuscator> getRegisteredPrivateKeyObfuscators() {
        Map<String, PrivateKeyObfuscator> map2 = OBFUSCATORS;
        synchronized (map2) {
            Collection<PrivateKeyObfuscator> l = OBFUSCATORS.values();
            if (GenericUtils.isEmpty(l)) {
                return Collections.emptyList();
            }
            return new ArrayList<PrivateKeyObfuscator>(l);
        }
    }

    public PrivateKeyEncryptionContext parseAlgorithmInfo(String algInfo) {
        return PrivateKeyEncryptionContext.parseAlgorithmInfo(this, algInfo);
    }

    public PrivateKeyEncryptionContext clone() {
        try {
            PrivateKeyEncryptionContext copy2 = (PrivateKeyEncryptionContext)this.getClass().cast(super.clone());
            byte[] v = copy2.getInitVector();
            if (v != null) {
                v = (byte[])v.clone();
                copy2.setInitVector(v);
            }
            return copy2;
        }
        catch (CloneNotSupportedException e2) {
            throw new UnsupportedOperationException("Failed to clone: " + this.toString());
        }
    }

    public int hashCode() {
        return GenericUtils.hashCode(this.getCipherName(), Boolean.TRUE) + GenericUtils.hashCode(this.getCipherType(), Boolean.TRUE) + GenericUtils.hashCode(this.getCipherMode(), Boolean.TRUE) + Objects.hashCode(this.getPassword()) + Arrays.hashCode(this.getInitVector());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrivateKeyEncryptionContext other = (PrivateKeyEncryptionContext)obj;
        return GenericUtils.safeCompare(this.getCipherName(), other.getCipherName(), false) == 0 && GenericUtils.safeCompare(this.getCipherType(), other.getCipherType(), false) == 0 && GenericUtils.safeCompare(this.getCipherMode(), other.getCipherMode(), false) == 0 && GenericUtils.safeCompare(this.getPassword(), other.getPassword(), true) == 0 && Arrays.equals(this.getInitVector(), other.getInitVector());
    }

    public String toString() {
        return GenericUtils.join(new String[]{this.getCipherName(), this.getCipherType(), this.getCipherMode()}, '-');
    }

    public static final <C extends PrivateKeyEncryptionContext> C parseAlgorithmInfo(C context, String algInfo) {
        ValidateUtils.checkNotNullAndNotEmpty(algInfo, "No encryption algorithm data");
        String[] cipherData = GenericUtils.split(algInfo, '-');
        ValidateUtils.checkTrue(cipherData.length == 3, "Bad encryption algorithm data: %s", (Object)algInfo);
        context.setCipherName(cipherData[0]);
        context.setCipherType(cipherData[1]);
        context.setCipherMode(cipherData[2]);
        return context;
    }

    public static final PrivateKeyEncryptionContext newPrivateKeyEncryptionContext(PrivateKeyObfuscator o, String password) {
        return PrivateKeyEncryptionContext.initializeObfuscator(new PrivateKeyEncryptionContext(), o, password);
    }

    public static final <C extends PrivateKeyEncryptionContext> C initializeObfuscator(C context, PrivateKeyObfuscator o, String password) {
        context.setCipherName(o.getCipherName());
        context.setPrivateKeyObfuscator(o);
        context.setPassword(password);
        return context;
    }
}

