/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHRSAPrivateKeyDecoder
extends AbstractPrivateKeyEntryDecoder<RSAPublicKey, RSAPrivateKey> {
    public static final BigInteger DEFAULT_PUBLIC_EXPONENT = KeyUtils.DEFAULT_RSA_PUBLIC_EXPONENT;
    public static final OpenSSHRSAPrivateKeyDecoder INSTANCE = new OpenSSHRSAPrivateKeyDecoder();

    public OpenSSHRSAPrivateKeyDecoder() {
        super(RSAPublicKey.class, RSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-rsa")));
    }

    @Override
    public RSAPrivateKey decodePrivateKey(SessionContext session2, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-rsa".equals(keyType)) {
            throw new InvalidKeySpecException("Unexpected key type: " + keyType);
        }
        BigInteger n = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger e2 = KeyEntryResolver.decodeBigInt(keyData);
        if (!Objects.equals(e2, DEFAULT_PUBLIC_EXPONENT)) {
            this.log.warn("decodePrivateKey({}) non-standard RSA exponent found: {}", (Object)keyType, (Object)e2);
        }
        BigInteger d2 = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger inverseQmodP = KeyEntryResolver.decodeBigInt(keyData);
        Objects.requireNonNull(inverseQmodP, "Missing iqmodp");
        BigInteger p = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger q = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger modulus = p.multiply(q);
        if (!Objects.equals(n, modulus)) {
            this.log.warn("decodePrivateKey({}) mismatched modulus values: encoded={}, calculated={}", keyType, n, modulus);
        }
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(n, e2, d2, p, q, d2.mod(p.subtract(BigInteger.ONE)), d2.mod(q.subtract(BigInteger.ONE)), inverseQmodP));
    }

    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s2, RSAPrivateKey key2, RSAPublicKey pubKey) throws IOException {
        Objects.requireNonNull(key2, "No private key provided");
        if (key2 instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey a2 = (RSAPrivateCrtKey)key2;
            KeyEntryResolver.encodeBigInt(s2, a2.getModulus());
            KeyEntryResolver.encodeBigInt(s2, a2.getPublicExponent());
            KeyEntryResolver.encodeBigInt(s2, a2.getPrivateExponent());
            KeyEntryResolver.encodeBigInt(s2, a2.getCrtCoefficient());
            KeyEntryResolver.encodeBigInt(s2, a2.getPrimeP());
            KeyEntryResolver.encodeBigInt(s2, a2.getPrimeQ());
            return "ssh-rsa";
        }
        return null;
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    @Override
    public RSAPublicKey recoverPublicKey(RSAPrivateKey privateKey) throws GeneralSecurityException {
        return KeyUtils.recoverRSAPublicKey(privateKey);
    }

    @Override
    public RSAPublicKey clonePublicKey(RSAPublicKey key2) throws GeneralSecurityException {
        if (key2 == null) {
            return null;
        }
        return (RSAPublicKey)this.generatePublicKey(new RSAPublicKeySpec(key2.getModulus(), key2.getPublicExponent()));
    }

    @Override
    public RSAPrivateKey clonePrivateKey(RSAPrivateKey key2) throws GeneralSecurityException {
        if (key2 == null) {
            return null;
        }
        if (!(key2 instanceof RSAPrivateCrtKey)) {
            throw new InvalidKeyException("Cannot clone a non-RSAPrivateCrtKey: " + key2.getClass().getSimpleName());
        }
        RSAPrivateCrtKey rsaPrv = (RSAPrivateCrtKey)key2;
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(rsaPrv.getModulus(), rsaPrv.getPublicExponent(), rsaPrv.getPrivateExponent(), rsaPrv.getPrimeP(), rsaPrv.getPrimeQ(), rsaPrv.getPrimeExponentP(), rsaPrv.getPrimeExponentQ(), rsaPrv.getCrtCoefficient()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("RSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("RSA");
    }
}

