/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.ssh2;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyTypeNamesSupport;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyRawDataDecoder;
import org.apache.sshd.common.config.keys.PublicKeyRawDataReader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class Ssh2PublicKeyEntryDecoder
implements PublicKeyRawDataDecoder<PublicKey>,
PublicKeyEntryResolver,
PublicKeyRawDataReader<PublicKey>,
KeyTypeNamesSupport {
    public static final NavigableSet<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"ssh-rsa", "ssh-dss", "ssh-ed25519", KeyPairProvider.ECDSA_SHA2_NISTP256, KeyPairProvider.ECDSA_SHA2_NISTP384, KeyPairProvider.ECDSA_SHA2_NISTP521}));
    public static final String BEGIN_MARKER = "BEGIN SSH2 PUBLIC KEY";
    public static final List<String> START_MARKERS = Collections.singletonList("BEGIN SSH2 PUBLIC KEY");
    public static final String END_MARKER = "END SSH2 PUBLIC KEY";
    public static final List<String> STOP_MARKERS = Collections.singletonList("END SSH2 PUBLIC KEY");
    public static final char HEADER_CONTINUATION_INDICATOR = '\\';
    public static final Ssh2PublicKeyEntryDecoder INSTANCE = new Ssh2PublicKeyEntryDecoder();

    @Override
    public NavigableSet<String> getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES;
    }

    @Override
    public PublicKey resolve(SessionContext session2, String keyType, byte[] keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePublicKey(session2, keyType, keyData, headers2);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    @Override
    public PublicKey decodePublicKey(SessionContext session2, String keyType, InputStream keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        return this.decodePublicKeyByType(session2, keyType, keyData, headers2);
    }

    @Override
    public PublicKey decodePublicKeyByType(SessionContext session2, String keyType, InputStream keyData, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.decodePublicKeyByType(session2, keyType, keyData, headers2);
    }

    @Override
    public PublicKey readPublicKey(SessionContext session2, NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        AbstractMap.SimpleImmutableEntry<Integer, Integer> markerPos = KeyPairResourceParser.findMarkerLine(lines, START_MARKERS);
        if (markerPos == null) {
            return null;
        }
        int startIndex = (Integer)markerPos.getKey();
        String startLine = lines.get(startIndex);
        if ((markerPos = KeyPairResourceParser.findMarkerLine(lines, ++startIndex, STOP_MARKERS)) == null) {
            throw new StreamCorruptedException("Missing end marker (END SSH2 PUBLIC KEY) after line #" + startIndex);
        }
        int endIndex = (Integer)markerPos.getKey();
        String endLine = lines.get(endIndex);
        Map.Entry<Map<String, String>, List<String>> result2 = this.separateDataLinesFromHeaders(session2, resourceKey, startLine, endLine, lines.subList(startIndex, endIndex));
        Map<String, String> headers2 = result2.getKey();
        List<String> dataLines = result2.getValue();
        return this.readPublicKey(session2, resourceKey, BEGIN_MARKER, END_MARKER, dataLines == null ? Collections.emptyList() : dataLines, headers2 == null ? Collections.emptyMap() : headers2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey readPublicKey(SessionContext session2, NamedResource resourceKey, String beginMarker, String endMarker, List<String> lines, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        byte[] dataBytes = KeyPairResourceParser.extractDataBytes(lines);
        try {
            PublicKey publicKey = this.readPublicKey(session2, resourceKey, beginMarker, endMarker, dataBytes, headers2);
            return publicKey;
        }
        finally {
            Arrays.fill(dataBytes, (byte)0);
        }
    }

    public PublicKey readPublicKey(SessionContext session2, NamedResource resourceKey, String beginMarker, String endMarker, byte[] dataBytes, Map<String, String> headers2) throws IOException, GeneralSecurityException {
        Map.Entry<String, Integer> result2 = KeyEntryResolver.decodeString(dataBytes, 256);
        String keyType = result2.getKey();
        return this.resolve(session2, keyType, dataBytes, headers2);
    }

    protected Map.Entry<Map<String, String>, List<String>> separateDataLinesFromHeaders(SessionContext session2, NamedResource resourceKey, String startLine, String endLine, List<String> lines) throws IOException, GeneralSecurityException {
        TreeMap<String, String> headers2 = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int len2 = lines.size();
        for (int index = 0; index < len2; ++index) {
            int vLen;
            String l = lines.get(index);
            if ((l = l.trim()).isEmpty()) continue;
            int pos = l.indexOf(58);
            if (pos < 0) {
                return new AbstractMap.SimpleImmutableEntry<Map<String, String>, List<String>>(headers2, lines.subList(index, len2));
            }
            String name = l.substring(0, pos).trim();
            String value2 = l.substring(pos + 1).trim();
            if (value2.charAt((vLen = value2.length()) - 1) == '\\') {
                value2 = value2.substring(0, vLen - 1);
                ++index;
                while (index < len2) {
                    l = lines.get(index);
                    if (l.charAt((vLen = l.length()) - 1) != '\\') {
                        value2 = value2 + l;
                        break;
                    }
                    value2 = value2 + l.substring(0, vLen - 1);
                    ++index;
                }
            }
            headers2.put(name, value2.trim());
        }
        throw new StreamCorruptedException("No viable data lines found in " + resourceKey.getName() + " after " + startLine);
    }
}

