/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.writer.openssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.AESPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCrypt;
import org.apache.sshd.common.config.keys.writer.KeyPairResourceWriter;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyEncryptionContext;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHKeyPairResourceWriter
implements KeyPairResourceWriter<OpenSSHKeyEncryptionContext> {
    public static final String DASHES = "-----";
    public static final int LINE_LENGTH = 70;
    public static final OpenSSHKeyPairResourceWriter INSTANCE = new OpenSSHKeyPairResourceWriter();
    private static final Pattern VERTICALSPACE = Pattern.compile("\\v");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePrivateKey(KeyPair key2, String comment, OpenSSHKeyEncryptionContext options2, OutputStream out2) throws IOException, GeneralSecurityException {
        Objects.requireNonNull(key2, "Cannot write null key");
        String keyType = KeyUtils.getKeyType(key2);
        if (GenericUtils.isEmpty(keyType)) {
            throw new GeneralSecurityException("Unsupported key: " + key2.getClass().getName());
        }
        OpenSSHKeyEncryptionContext opt = OpenSSHKeyPairResourceWriter.determineEncryption(options2);
        OpenSSHKeyPairResourceWriter.write(out2, "-----BEGIN OPENSSH PRIVATE KEY-----");
        out2.write(10);
        String cipherName = "none";
        int blockSize = 8;
        if (opt != null) {
            cipherName = opt.getCipherFactoryName();
            BuiltinCiphers spec = BuiltinCiphers.fromFactoryName(cipherName);
            if (spec == null) {
                throw new IllegalArgumentException("Unsupported cipher " + cipherName);
            }
            blockSize = spec.getCipherBlockSize();
        }
        byte[] privateBytes = OpenSSHKeyPairResourceWriter.encodePrivateKey(key2, keyType, blockSize, comment);
        String kdfName = "none";
        byte[] kdfOptions = GenericUtils.EMPTY_BYTE_ARRAY;
        try (SecureByteArrayOutputStream bytes = new SecureByteArrayOutputStream();){
            OpenSSHKeyPairResourceWriter.write(bytes, "openssh-key-v1");
            bytes.write(0);
            if (opt != null) {
                KeyEncryptor encryptor = new KeyEncryptor(opt);
                opt.setPrivateKeyObfuscator(encryptor);
                byte[] encodedBytes = encryptor.applyPrivateKeyCipher(privateBytes, opt, true);
                Arrays.fill(privateBytes, (byte)0);
                privateBytes = encodedBytes;
                kdfName = "bcrypt";
                kdfOptions = encryptor.getKdfOptions();
            }
            KeyEntryResolver.encodeString(bytes, cipherName);
            KeyEntryResolver.encodeString(bytes, kdfName);
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, kdfOptions);
            KeyEntryResolver.encodeInt(bytes, 1);
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, OpenSSHKeyPairResourceWriter.encodePublicKey(key2.getPublic(), keyType));
            KeyEntryResolver.writeRLEBytes((OutputStream)bytes, privateBytes);
            OpenSSHKeyPairResourceWriter.write(out2, bytes.toByteArray(), 70);
        }
        finally {
            Arrays.fill(privateBytes, (byte)0);
        }
        OpenSSHKeyPairResourceWriter.write(out2, "-----END OPENSSH PRIVATE KEY-----");
        out2.write(10);
    }

    public static OpenSSHKeyEncryptionContext determineEncryption(OpenSSHKeyEncryptionContext options2) {
        String password;
        String string = password = options2 == null ? null : options2.getPassword();
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int len2 = password.length();
        for (int pos = 0; pos < len2; ++pos) {
            char ch = password.charAt(pos);
            if (Character.isWhitespace(ch)) continue;
            return options2;
        }
        return null;
    }

    public static byte[] encodePrivateKey(KeyPair key2, String keyType, int blockSize, String comment) throws IOException, GeneralSecurityException {
        try (SecureByteArrayOutputStream out2 = new SecureByteArrayOutputStream();){
            int size2;
            int extra;
            int check2 = JceRandom.getGlobalInstance().nextInt();
            KeyEntryResolver.encodeInt(out2, check2);
            KeyEntryResolver.encodeInt(out2, check2);
            KeyEntryResolver.encodeString(out2, keyType);
            PrivateKeyEntryDecoder<?, ?> encoder2 = OpenSSHKeyPairResourceParser.getPrivateKeyEntryDecoder(keyType);
            if (encoder2.encodePrivateKey(out2, key2.getPrivate(), key2.getPublic()) == null) {
                throw new GeneralSecurityException("Cannot encode key of type " + keyType);
            }
            KeyEntryResolver.encodeString(out2, comment == null ? "" : comment);
            if (blockSize > 1 && (extra = (size2 = out2.size()) % blockSize) != 0) {
                for (int i2 = 1; i2 <= blockSize - extra; ++i2) {
                    out2.write(i2 & 0xFF);
                }
            }
            byte[] byArray = out2.toByteArray();
            return byArray;
        }
    }

    public static byte[] encodePublicKey(PublicKey key2, String keyType) throws IOException, GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new GeneralSecurityException("Unknown key type: " + keyType);
        }
        try (ByteArrayOutputStream out2 = new ByteArrayOutputStream();){
            decoder.encodePublicKey(out2, key2);
            byte[] byArray = out2.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out2, byte[] bytes, int lineLength) throws IOException {
        byte[] encoded = Base64.getEncoder().encode(bytes);
        Arrays.fill(bytes, (byte)0);
        try {
            int last2 = encoded.length;
            for (int i2 = 0; i2 < last2; i2 += lineLength) {
                if (i2 + lineLength <= last2) {
                    out2.write(encoded, i2, lineLength);
                } else {
                    out2.write(encoded, i2, last2 - i2);
                }
                out2.write(10);
            }
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    @Override
    public void writePublicKey(PublicKey key2, String comment, OutputStream out2) throws IOException, GeneralSecurityException {
        StringBuilder b2 = new StringBuilder(82);
        PublicKeyEntry.appendPublicKeyEntry(b2, key2);
        String line = OpenSSHKeyPairResourceWriter.firstLine(comment);
        if (GenericUtils.isNotEmpty(line)) {
            b2.append(' ').append(line);
        }
        OpenSSHKeyPairResourceWriter.write(out2, b2.toString());
    }

    public static String firstLine(String text) {
        Matcher m4;
        if (GenericUtils.isNotEmpty(text) && (m4 = VERTICALSPACE.matcher(text)).find()) {
            return text.substring(0, m4.start()).trim();
        }
        return text;
    }

    public static void write(OutputStream out2, String s2) throws IOException {
        out2.write(s2.getBytes(StandardCharsets.UTF_8));
    }

    public static class KeyEncryptor
    extends AESPrivateKeyObfuscator {
        public static final int BCRYPT_SALT_LENGTH = 16;
        protected final OpenSSHKeyEncryptionContext options;
        private byte[] kdfOptions;

        public KeyEncryptor(OpenSSHKeyEncryptionContext options2) {
            this.options = Objects.requireNonNull(options2);
        }

        public byte[] getKdfOptions() {
            return this.kdfOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext context, int keyLength) throws IOException, GeneralSecurityException {
            if (SecurityUtils.isFipsMode()) {
                throw new NoSuchAlgorithmException("bcrypt is disabled in FIPS mode");
            }
            byte[] iv = context.getInitVector();
            if (iv == null) {
                iv = this.generateInitializationVector(context);
            }
            byte[] salt = new byte[16];
            Random random2 = JceRandomFactory.INSTANCE.create();
            random2.fill(salt);
            byte[] kdfOutput = new byte[keyLength + iv.length];
            BCrypt bcrypt = new BCrypt();
            try {
                byte[] byArray;
                try (ByteArrayOutputStream kdf = new ByteArrayOutputStream();){
                    int rounds = this.options.getKdfRounds();
                    byte[] pwd = this.convert(this.options.getPassword());
                    try {
                        bcrypt.pbkdf(pwd, salt, rounds, kdfOutput);
                    }
                    finally {
                        if (pwd != null) {
                            Arrays.fill(pwd, (byte)0);
                        }
                    }
                    KeyEntryResolver.writeRLEBytes((OutputStream)kdf, salt);
                    KeyEntryResolver.encodeInt(kdf, rounds);
                    this.kdfOptions = kdf.toByteArray();
                    context.setInitVector(Arrays.copyOfRange(kdfOutput, keyLength, kdfOutput.length));
                    byArray = Arrays.copyOf(kdfOutput, keyLength);
                }
                return byArray;
            }
            finally {
                Arrays.fill(kdfOutput, (byte)0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] convert(String password) {
            ByteBuffer bytes;
            if (GenericUtils.isEmpty(password)) {
                return GenericUtils.EMPTY_BYTE_ARRAY;
            }
            char[] pass2 = password.toCharArray();
            try {
                bytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pass2));
            }
            finally {
                Arrays.fill(pass2, '\u0000');
            }
            byte[] pwd = new byte[bytes.remaining()];
            bytes.get(pwd);
            if (bytes.hasArray()) {
                Arrays.fill(bytes.array(), (byte)0);
            }
            return pwd;
        }
    }
}

