/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class DigestUtils {
    private DigestUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean checkSupported(String algorithm) {
        ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        try {
            MessageDigest digest = SecurityUtils.getMessageDigest(algorithm);
            return digest != null;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static <D extends Digest> D findDigestByAlgorithm(String algo, Comparator<? super String> comp, Collection<? extends D> digests) {
        if (GenericUtils.isEmpty(algo) || GenericUtils.isEmpty(digests)) {
            return null;
        }
        for (Digest d2 : digests) {
            if (comp.compare(algo, d2.getAlgorithm()) != 0) continue;
            return (D)d2;
        }
        return null;
    }

    public static <F extends DigestFactory> F findFactoryByAlgorithm(String algo, Comparator<? super String> comp, Collection<? extends F> factories) {
        if (GenericUtils.isEmpty(algo) || GenericUtils.isEmpty(factories)) {
            return null;
        }
        for (DigestFactory f2 : factories) {
            if (comp.compare(algo, f2.getAlgorithm()) != 0) continue;
            return (F)f2;
        }
        return null;
    }

    public static String getFingerPrint(Factory<? extends Digest> f2, String s2) throws Exception {
        return DigestUtils.getFingerPrint(f2, s2, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory<? extends Digest> f2, String s2, Charset charset) throws Exception {
        return DigestUtils.getFingerPrint(Objects.requireNonNull(f2, "No factory").create(), s2, charset);
    }

    public static String getFingerPrint(Digest d2, String s2) throws Exception {
        return DigestUtils.getFingerPrint(d2, s2, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest d2, String s2, Charset charset) throws Exception {
        if (GenericUtils.isEmpty(s2)) {
            return null;
        }
        return DigestUtils.getFingerPrint(d2, s2.getBytes(charset));
    }

    public static String getFingerPrint(Factory<? extends Digest> f2, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(f2, buf, 0, NumberUtils.length(buf));
    }

    public static String getFingerPrint(Factory<? extends Digest> f2, byte[] buf, int offset, int len2) throws Exception {
        return DigestUtils.getFingerPrint(Objects.requireNonNull(f2, "No factory").create(), buf, offset, len2);
    }

    public static String getFingerPrint(Digest d2, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(d2, buf, 0, NumberUtils.length(buf));
    }

    public static String getFingerPrint(Digest d2, byte[] buf, int offset, int len2) throws Exception {
        if (len2 <= 0) {
            return null;
        }
        byte[] data2 = DigestUtils.getRawFingerprint(d2, buf, offset, len2);
        String algo = d2.getAlgorithm();
        if (BuiltinDigests.md5.getAlgorithm().equals(algo)) {
            return algo + ":" + BufferUtils.toHex(':', data2).toLowerCase();
        }
        Base64.Encoder encoder2 = Base64.getEncoder();
        return algo.replace("-", "").toUpperCase() + ":" + encoder2.encodeToString(data2).replaceAll("=", "");
    }

    public static byte[] getRawFingerprint(Digest d2, byte ... buf) throws Exception {
        return DigestUtils.getRawFingerprint(d2, buf, 0, NumberUtils.length(buf));
    }

    public static byte[] getRawFingerprint(Digest d2, byte[] buf, int offset, int len2) throws Exception {
        if (len2 <= 0) {
            return null;
        }
        Objects.requireNonNull(d2, "No digest").init();
        d2.update(buf, offset, len2);
        return d2.digest();
    }
}

