/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.file.root.RootedDirectoryStream;
import org.apache.sshd.common.file.root.RootedFileSystem;
import org.apache.sshd.common.file.root.RootedFileSystemUtils;
import org.apache.sshd.common.file.root.RootedPath;
import org.apache.sshd.common.file.root.RootedSecureDirectoryStream;
import org.apache.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootedFileSystemProvider
extends FileSystemProvider {
    protected final Logger log;
    private final Map<Path, RootedFileSystem> fileSystems = new HashMap<Path, RootedFileSystem>();

    public RootedFileSystemProvider() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public String getScheme() {
        return "root";
    }

    @Override
    public FileSystem newFileSystem(URI uri2, Map<String, ?> env) throws IOException {
        return this.newFileSystem(uri2, this.uriToPath(uri2), env);
    }

    @Override
    public FileSystem getFileSystem(URI uri2) {
        return this.getFileSystem(this.uriToPath(uri2));
    }

    @Override
    public FileSystem newFileSystem(Path path2, Map<String, ?> env) throws IOException {
        return this.newFileSystem(path2, path2, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem newFileSystem(Object src, Path path2, Map<String, ?> env) throws IOException {
        Path root = RootedFileSystemProvider.ensureDirectory(path2).toRealPath(new LinkOption[0]);
        RootedFileSystem rootedFs = null;
        Map<Path, RootedFileSystem> map2 = this.fileSystems;
        synchronized (map2) {
            if (!this.fileSystems.containsKey(root)) {
                rootedFs = new RootedFileSystem(this, path2, env);
                this.fileSystems.put(root, rootedFs);
            }
        }
        if (rootedFs == null) {
            throw new FileSystemAlreadyExistsException("newFileSystem(" + src + ") already mapped " + root);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newFileSystem({}): {}", src, (Object)rootedFs);
        }
        return rootedFs;
    }

    protected Path uriToPath(URI uri2) {
        String scheme2 = uri2.getScheme();
        String expected = this.getScheme();
        if (scheme2 == null || !scheme2.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException("URI scheme (" + scheme2 + ") is not '" + expected + "'");
        }
        String root = uri2.getRawSchemeSpecificPart();
        int i2 = root.indexOf("!/");
        if (i2 != -1) {
            root = root.substring(0, i2);
        }
        try {
            return Paths.get(new URI(root)).toAbsolutePath();
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(root + ": " + e2.getMessage(), e2);
        }
    }

    private static Path ensureDirectory(Path path2) {
        return IoUtils.ensureDirectory(path2, IoUtils.getLinkOptions(true));
    }

    @Override
    public Path getPath(URI uri2) {
        String str = uri2.getSchemeSpecificPart();
        int i2 = str.indexOf("!/");
        if (i2 == -1) {
            throw new IllegalArgumentException("URI: " + uri2 + " does not contain path info - e.g., root:file://foo/bar!/");
        }
        FileSystem fs = this.getFileSystem(uri2);
        String subPath = str.substring(i2 + 1);
        Path p = fs.getPath(subPath, new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}): {}", (Object)uri2, (Object)p);
        }
        return p;
    }

    @Override
    public InputStream newInputStream(Path path2, OpenOption ... options2) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newInputStream(r, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public OutputStream newOutputStream(Path path2, OpenOption ... options2) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newOutputStream(r, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public FileChannel newFileChannel(Path path2, Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newFileChannel(r, options2, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path2, Set<? extends OpenOption> options2, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newAsynchronousFileChannel(r, options2, executor, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newByteChannel(r, options2, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        try {
            return this.root((RootedFileSystem)((RootedPath)dir).getFileSystem(), p.newDirectoryStream(r, filter2));
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, dir);
        }
    }

    protected DirectoryStream<Path> root(RootedFileSystem rfs, DirectoryStream<Path> ds) {
        if (ds instanceof SecureDirectoryStream) {
            return new RootedSecureDirectoryStream(rfs, (SecureDirectoryStream)ds);
        }
        return new RootedDirectoryStream(rfs, ds);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        try {
            p.createDirectory(r, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, dir);
        }
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        RootedFileSystemUtils.validateSafeRelativeSymlink(target);
        Path l = this.unroot(link);
        Path t2 = target.isAbsolute() ? this.unroot(target) : l.getFileSystem().getPath(target.toString(), new String[0]);
        FileSystemProvider p = this.provider(l);
        try {
            p.createSymbolicLink(l, t2, attrs);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSymbolicLink({} => {}", (Object)l, (Object)t2);
            }
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        Path l = this.unroot(link);
        Path t2 = this.unroot(existing);
        try {
            this.provider(l).createLink(l, t2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createLink({} => {}", (Object)l, (Object)t2);
            }
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void delete(Path path2) throws IOException {
        Path r = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("delete({}): {}", (Object)path2, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        try {
            p.delete(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public boolean deleteIfExists(Path path2) throws IOException {
        Path r = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("deleteIfExists({}): {}", (Object)path2, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        try {
            return p.deleteIfExists(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        Path r = this.unroot(link);
        FileSystemProvider p = this.provider(r);
        try {
            Path t2 = p.readSymbolicLink(r);
            Path target = this.root((RootedFileSystem)link.getFileSystem(), t2);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readSymbolicLink({})[{}]: {}[{}]", link, r, target, t2);
            }
            return target;
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void copy(Path source2, Path target, CopyOption ... options2) throws IOException {
        Path s2 = this.unroot(source2);
        Path t2 = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("copy({})[{}]: {}[{}]", source2, s2, target, t2);
        }
        FileSystemProvider p = this.provider(s2);
        try {
            p.copy(s2, t2, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, source2);
        }
    }

    @Override
    public void move(Path source2, Path target, CopyOption ... options2) throws IOException {
        Path s2 = this.unroot(source2);
        Path t2 = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("move({})[{}]: {}[{}]", source2, s2, target, t2);
        }
        FileSystemProvider p = this.provider(s2);
        try {
            p.move(s2, t2, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, source2);
        }
    }

    @Override
    public boolean isSameFile(Path path2, Path path22) throws IOException {
        Path r = this.unroot(path2);
        Path r2 = this.unroot(path22);
        FileSystemProvider p = this.provider(r);
        try {
            return p.isSameFile(r, r2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public boolean isHidden(Path path2) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.isHidden(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public FileStore getFileStore(Path path2) throws IOException {
        RootedFileSystem fileSystem = this.getFileSystem(path2);
        Path root = fileSystem.getRoot();
        try {
            return Files.getFileStore(root);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootedFileSystem getFileSystem(Path path2) throws FileSystemNotFoundException {
        Path real = this.unroot(path2);
        Path rootInstance = null;
        RootedFileSystem fsInstance = null;
        Map<Path, RootedFileSystem> map2 = this.fileSystems;
        synchronized (map2) {
            for (Map.Entry<Path, RootedFileSystem> fse : this.fileSystems.entrySet()) {
                Path root = fse.getKey();
                RootedFileSystem fs = fse.getValue();
                if (real.equals(root)) {
                    return fs;
                }
                if (!real.startsWith(root) || rootInstance != null && rootInstance.getNameCount() >= root.getNameCount()) continue;
                rootInstance = root;
                fsInstance = fs;
            }
        }
        if (fsInstance == null) {
            throw new FileSystemNotFoundException(path2.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getFileSystem({}): {}", (Object)path2, (Object)fsInstance);
        }
        return fsInstance;
    }

    @Override
    public void checkAccess(Path path2, AccessMode ... modes) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            p.checkAccess(r, modes);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path2, Class<V> type2, LinkOption ... options2) {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        return p.getFileAttributeView(r, type2, options2);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path2, Class<A> type2, LinkOption ... options2) throws IOException {
        Path r = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readAttributes({})[{}] type={}", path2, r, type2.getSimpleName());
        }
        FileSystemProvider p = this.provider(r);
        try {
            return p.readAttributes(r, type2, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path2, String attributes2, LinkOption ... options2) throws IOException {
        Path r = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            Map<String, Object> attrs = p.readAttributes(r, attributes2, options2);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readAttributes({})[{}] {}: {}", path2, r, attributes2, attrs);
            }
            return attrs;
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    @Override
    public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options2) throws IOException {
        Path r = this.unroot(path2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("setAttribute({})[{}] {}={}", path2, r, attribute, value2);
        }
        FileSystemProvider p = this.provider(r);
        try {
            p.setAttribute(r, attribute, value2, options2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path2);
        }
    }

    protected FileSystemProvider provider(Path path2) {
        FileSystem fs = path2.getFileSystem();
        return fs.provider();
    }

    protected Path root(RootedFileSystem rfs, Path nat) {
        if (nat.isAbsolute()) {
            if (nat.startsWith(rfs.getRoot())) {
                if (nat.getNameCount() == rfs.getRoot().getNameCount()) {
                    return rfs.getPath("/", new String[0]);
                }
                String firstName = "/" + nat.getName(rfs.getRoot().getNameCount());
                String[] varargs = new String[nat.getNameCount() - rfs.getRoot().getNameCount() - 1];
                int varargsCounter = 0;
                for (int i2 = 1 + rfs.getRoot().getNameCount(); i2 < nat.getNameCount(); ++i2) {
                    varargs[varargsCounter++] = nat.getName(i2).toString();
                }
                return rfs.getPath(firstName, varargs);
            }
            Path root = rfs.getRoot();
            Path rel = root.relativize(nat);
            return rfs.getPath("/" + rel, new String[0]);
        }
        return rfs.getPath(nat.toString(), new String[0]);
    }

    protected Path unroot(Path path2) {
        Objects.requireNonNull(path2, "No path to unroot");
        if (!(path2 instanceof RootedPath)) {
            throw new ProviderMismatchException("unroot(" + path2 + ") is not a " + RootedPath.class.getSimpleName() + " but rather a " + path2.getClass().getSimpleName());
        }
        return this.resolveLocalPath((RootedPath)path2);
    }

    protected Path resolveLocalPath(RootedPath path2) {
        Objects.requireNonNull(path2, "No rooted path to resolve");
        RootedFileSystem rfs = (RootedFileSystem)path2.getFileSystem();
        Path root = rfs.getRoot();
        Path resolved2 = IoUtils.chroot(root, path2);
        if (!resolved2.normalize().startsWith(root)) {
            throw new InvalidPathException(root.toString(), "Not under root");
        }
        return resolved2;
    }

    private IOException translateIoException(IOException ex, Path rootedPath) {
        RootedPath rootedPathCasted = (RootedPath)rootedPath;
        Path root = ((RootedFileSystem)rootedPathCasted.getFileSystem()).getRoot();
        if (ex instanceof FileSystemException) {
            String file2 = this.fixExceptionFileName(root, rootedPath, ((FileSystemException)ex).getFile());
            String otherFile = this.fixExceptionFileName(root, rootedPath, ((FileSystemException)ex).getOtherFile());
            String reason = ((FileSystemException)ex).getReason();
            if (NoSuchFileException.class.equals(ex.getClass())) {
                return new NoSuchFileException(file2, otherFile, reason);
            }
            if (FileSystemLoopException.class.equals(ex.getClass())) {
                return new FileSystemLoopException(file2);
            }
            if (NotDirectoryException.class.equals(ex.getClass())) {
                return new NotDirectoryException(file2);
            }
            if (DirectoryNotEmptyException.class.equals(ex.getClass())) {
                return new DirectoryNotEmptyException(file2);
            }
            if (NotLinkException.class.equals(ex.getClass())) {
                return new NotLinkException(file2);
            }
            if (AtomicMoveNotSupportedException.class.equals(ex.getClass())) {
                return new AtomicMoveNotSupportedException(file2, otherFile, reason);
            }
            if (FileAlreadyExistsException.class.equals(ex.getClass())) {
                return new FileAlreadyExistsException(file2, otherFile, reason);
            }
            if (AccessDeniedException.class.equals(ex.getClass())) {
                return new AccessDeniedException(file2, otherFile, reason);
            }
            return new FileSystemException(file2, otherFile, reason);
        }
        if (ex.getClass().equals(FileNotFoundException.class)) {
            return new FileNotFoundException(ex.getLocalizedMessage().replace(root.toString(), ""));
        }
        return ex;
    }

    private String fixExceptionFileName(Path root, Path rootedPath, String fileName) {
        if (fileName == null) {
            return null;
        }
        Path toFix = root.getFileSystem().getPath(fileName, new String[0]);
        if (toFix.getNameCount() == root.getNameCount()) {
            return rootedPath.getFileSystem().getSeparator();
        }
        StringBuilder ret = new StringBuilder();
        for (int partNum = root.getNameCount(); partNum < toFix.getNameCount(); ++partNum) {
            ret.append(rootedPath.getFileSystem().getSeparator());
            ret.append(toFix.getName(partNum++));
        }
        return ret.toString();
    }
}

