/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import org.apache.sshd.common.file.root.RootedFileSystem;
import org.apache.sshd.common.file.util.BasePath;

public class RootedPath
extends BasePath<RootedPath, RootedFileSystem> {
    public RootedPath(RootedFileSystem fileSystem, String root, List<String> names2) {
        super(fileSystem, root, names2);
    }

    @Override
    public File toFile() {
        RootedPath absolute = (RootedPath)this.toAbsolutePath();
        RootedFileSystem fs = (RootedFileSystem)this.getFileSystem();
        Path path2 = fs.getRoot();
        for (String n : absolute.names) {
            path2 = path2.resolve(n);
        }
        return path2.toFile();
    }

    @Override
    public RootedPath toRealPath(LinkOption ... options2) throws IOException {
        RootedPath absolute = (RootedPath)this.toAbsolutePath();
        FileSystem fs = this.getFileSystem();
        FileSystemProvider provider2 = fs.provider();
        provider2.checkAccess(absolute, new AccessMode[0]);
        return absolute;
    }
}

