/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Set;
import org.apache.sshd.common.file.root.RootedDirectoryStream;
import org.apache.sshd.common.file.root.RootedFileSystem;

public class RootedSecureDirectoryStream
extends RootedDirectoryStream
implements SecureDirectoryStream<Path> {
    public RootedSecureDirectoryStream(RootedFileSystem rfs, SecureDirectoryStream<Path> delegate) {
        super(rfs, delegate);
    }

    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path path2, LinkOption ... options2) throws IOException {
        return new RootedSecureDirectoryStream(this.rfs, this.delegate().newDirectoryStream(this.fixPath(path2), options2));
    }

    protected Path fixPath(Path p) {
        if (p.isAbsolute()) {
            return this.rfs.provider().unroot(p);
        }
        return this.rfs.getRootFileSystem().getPath(p.toString(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate().newByteChannel(this.fixPath(path2), options2, attrs);
    }

    @Override
    public void deleteFile(Path path2) throws IOException {
        this.delegate().deleteFile(this.fixPath(path2));
    }

    @Override
    public void deleteDirectory(Path path2) throws IOException {
        this.delegate().deleteDirectory(this.fixPath(path2));
    }

    @Override
    public void move(Path srcpath, SecureDirectoryStream<Path> targetdir, Path targetpath) throws IOException {
        this.delegate().move(this.fixPath(srcpath), targetdir, targetpath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type2) {
        return this.delegate().getFileAttributeView(type2);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path2, Class<V> type2, LinkOption ... options2) {
        return this.delegate().getFileAttributeView(path2, type2, options2);
    }

    private SecureDirectoryStream<Path> delegate() {
        return (SecureDirectoryStream)this.delegate;
    }
}

