/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileSystem<T extends Path>
extends FileSystem {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemProvider fileSystemProvider;

    protected BaseFileSystem(FileSystemProvider fileSystemProvider) {
        this.fileSystemProvider = Objects.requireNonNull(fileSystemProvider, "No file system provider");
    }

    public T getDefaultDir() {
        return this.getPath("/", new String[0]);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FileSystemProvider provider() {
        return this.fileSystemProvider;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.create("/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("No file stores available");
    }

    public T getPath(String first2, String ... more) {
        StringBuilder sb = new StringBuilder();
        if (!GenericUtils.isEmpty(first2)) {
            this.appendDedupSep(sb, this.handleWindowsSeparator(first2));
        }
        if (GenericUtils.length(more) > 0) {
            for (String segment : more) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
                this.appendDedupSep(sb, this.handleWindowsSeparator(segment));
            }
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        String path2 = sb.toString();
        String root = null;
        if (path2.startsWith("/")) {
            root = "/";
            path2 = path2.substring(1);
        }
        String[] names2 = GenericUtils.split(path2, '/');
        T p = this.create(root, names2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}, {}): {}", first2, Arrays.toString(more), p);
        }
        return p;
    }

    protected void appendDedupSep(StringBuilder sb, CharSequence s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch = s2.charAt(i2);
            if (ch == '/' && sb.length() != 0 && sb.charAt(sb.length() - 1) == '/') continue;
            sb.append(ch);
        }
    }

    protected String handleWindowsSeparator(String name) {
        if (this.hostFsHasWindowsSeparator()) {
            return name.replace('\\', '/');
        }
        return name;
    }

    protected boolean hostFsHasWindowsSeparator() {
        return OsUtils.isWin32();
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        String expr;
        int colonIndex = Objects.requireNonNull(syntaxAndPattern, "No argument").indexOf(58);
        if (colonIndex <= 0 || colonIndex == syntaxAndPattern.length() - 1) {
            throw new IllegalArgumentException("syntaxAndPattern must have form \"syntax:pattern\" but was \"" + syntaxAndPattern + "\"");
        }
        String syntax = syntaxAndPattern.substring(0, colonIndex);
        String pattern2 = syntaxAndPattern.substring(colonIndex + 1);
        switch (syntax) {
            case "glob": {
                expr = this.globToRegex(pattern2);
                break;
            }
            case "regex": {
                expr = pattern2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported path matcher syntax: '" + syntax + "'");
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPathMatcher({}): {}", (Object)syntaxAndPattern, (Object)expr);
        }
        Pattern regex = Pattern.compile(expr);
        return path2 -> {
            Matcher m4 = regex.matcher(path2.toString());
            return m4.matches();
        };
    }

    protected String globToRegex(String pattern2) {
        StringBuilder sb = new StringBuilder(Objects.requireNonNull(pattern2, "No pattern").length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern2.toCharArray();
        block16: for (int i2 = 0; i2 < arr.length; ++i2) {
            char ch = arr[i2];
            switch (ch) {
                case '\\': {
                    if (++i2 >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next2 = arr[i2];
                    switch (next2) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next2);
                    continue block16;
                }
                case '*': {
                    sb.append(inClass == 0 ? ".*" : "*");
                    continue block16;
                }
                case '?': {
                    sb.append(inClass == 0 ? (char)'.' : '?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i2 + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i2 && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    sb.append(firstIndexInClass == i2 ? (char)'^' : '!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    sb.append(inGroup > 0 ? (char)'|' : ',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        String regex = sb.toString();
        if (this.log.isTraceEnabled()) {
            this.log.trace("globToRegex({}): {}", (Object)pattern2, (Object)regex);
        }
        return regex;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Watch service N/A");
    }

    protected T create(String root, String ... names2) {
        return this.create(root, GenericUtils.unmodifiableList(names2));
    }

    protected T create(String root, Collection<String> names2) {
        return this.create(root, GenericUtils.unmodifiableList(names2));
    }

    protected abstract T create(String var1, List<String> var2);
}

