/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ChannelToPortHandler
extends AbstractLoggingBean {
    private final IoSession port;
    private final Channel channel;

    public ChannelToPortHandler(IoSession port2, Channel channel2) {
        this.port = Objects.requireNonNull(port2, "No port IoSession");
        this.channel = Objects.requireNonNull(channel2, "No Channel");
    }

    public IoSession getPortSession() {
        return this.port;
    }

    public void handleEof() throws IOException {
        this.port.shutdownOutputStream();
    }

    public void sendToPort(byte cmd, byte[] data2, int off, long len2) throws IOException {
        ValidateUtils.checkTrue(len2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len2);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data2, off, (int)len2);
        this.port.writeBuffer(buf).addListener(future -> {
            if (future.isWritten()) {
                this.handleWriteDataSuccess(cmd, buf.array(), 0, (int)len2);
            } else {
                this.handleWriteDataFailure(cmd, buf.array(), 0, (int)len2, future.getException());
            }
        });
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data2, int off, int len2) {
        this.checkWindow(cmd, len2);
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data2, int off, int len2, Throwable t2) {
        this.debug("handleWriteDataFailure({}, {})[{}] failed ({}) to write len={}: {}", this.channel, this.port, SshConstants.getCommandMessageName(cmd & 0xFF), t2.getClass().getSimpleName(), len2, t2.getMessage(), t2);
        if (this.port.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), this.port);
            }
            this.checkWindow(cmd, len2);
            this.channel.close(false);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] ignoring writeDataFailure {} because ioSession {} is already closing ", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), t2, this.port);
            }
            this.checkWindow(cmd, len2);
        }
    }

    private void checkWindow(byte cmd, long len2) {
        try {
            LocalWindow wLocal = this.channel.getLocalWindow();
            if (wLocal.isOpen()) {
                wLocal.release(len2);
            }
        }
        catch (Throwable e2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to check local window: {}", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), e2.getClass().getSimpleName(), e2.getMessage());
            }
            this.channel.getSession().exceptionCaught(e2);
        }
    }
}

