/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManagerHolder;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipForwardingExceptionMarker;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoHandlerFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.io.functors.Invoker;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.TcpForwardingFilter;

public class DefaultForwarder
extends AbstractInnerCloseable
implements Forwarder,
SessionHolder<Session> {
    public static final Set<ClientChannelEvent> STATIC_IO_MSG_RECEIVED_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.OPENED, ClientChannelEvent.CLOSED));
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = () -> new SocksProxy(this.getConnectionService());
    private final Session sessionInstance;
    private final Object localLock = new Object();
    private final Map<SshdSocketAddress, SshdSocketAddress> localToRemote = new HashMap<SshdSocketAddress, SshdSocketAddress>();
    private final Map<SshdSocketAddress, InetSocketAddress> boundLocals = new HashMap<SshdSocketAddress, InetSocketAddress>();
    private final Object dynamicLock = new Object();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SocksProxy> dynamicLocal = new HashMap<Integer, SocksProxy>();
    private final Map<Integer, InetSocketAddress> boundDynamic = new HashMap<Integer, InetSocketAddress>();
    private final Set<LocalForwardingEntry> localForwards = new HashSet<LocalForwardingEntry>();
    private final IoHandlerFactory staticIoHandlerFactory = () -> new StaticIoHandler();
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final Collection<PortForwardingEventListenerManager> managersHolder = new CopyOnWriteArraySet<PortForwardingEventListenerManager>();
    private final PortForwardingEventListener listenerProxy;
    private IoAcceptor localAcceptor;
    private IoAcceptor dynamicAcceptor;

    public DefaultForwarder(ConnectionService service) {
        this.service = Objects.requireNonNull(service, "No connection service");
        this.sessionInstance = (Session)Objects.requireNonNull(service.getSession(), "No session");
        this.listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Collection<PortForwardingEventListenerManager> getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList<PortForwardingEventListenerManager>(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        return this.managersHolder.add(Objects.requireNonNull(manager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        if (manager == null) {
            return false;
        }
        return this.managersHolder.remove(manager);
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    protected Collection<PortForwardingEventListener> getDefaultListeners() {
        ArrayList<PortForwardingEventListener> defaultListeners = new ArrayList<PortForwardingEventListener>();
        defaultListeners.add(this.getPortForwardingEventListenerProxy());
        Session session2 = this.getSession();
        PortForwardingEventListener l = session2.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        FactoryManager manager = session2 == null ? null : session2.getFactoryManager();
        PortForwardingEventListener portForwardingEventListener = l = manager == null ? null : manager.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        return defaultListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        SshdSocketAddress result2;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        Objects.requireNonNull(remote, "Remote address is null");
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closed or closing: " + this.state);
        }
        this.signalEstablishingExplicitTunnel(local, remote, true);
        InetSocketAddress bound = null;
        try {
            bound = this.doBind(local, this.getLocalIoAcceptor());
            int port2 = bound.getPort();
            result2 = new SshdSocketAddress(bound.getHostString(), port2);
            Object object = this.localLock;
            synchronized (object) {
                SshdSocketAddress prevRemote = SshdSocketAddress.findByOptionalWildcardAddress(this.localToRemote, result2);
                if (prevRemote != null) {
                    throw new IOException("Multiple local port forwarding addressing on port=" + result2 + ": current=" + remote + ", previous=" + prevRemote);
                }
                InetSocketAddress prevBound = SshdSocketAddress.findByOptionalWildcardAddress(this.boundLocals, result2);
                if (prevBound != null) {
                    throw new IOException("Multiple local port forwarding bindings on port=" + result2 + ": current=" + bound + ", previous=" + prevBound);
                }
                this.localToRemote.put(result2, remote);
                this.boundLocals.put(result2, bound);
            }
        }
        catch (IOException | RuntimeException e2) {
            try {
                this.unbindLocalForwarding(local, remote, bound);
            }
            catch (IOException | RuntimeException err) {
                e2.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, null, e2);
            throw e2;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startLocalPortForwarding({} -> {}): {}", local, remote, result2);
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, result2, null);
            return result2;
        }
        catch (IOException | RuntimeException e3) {
            this.stopLocalPortForwarding(local);
            throw e3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SshdSocketAddress remote;
        Objects.requireNonNull(local, "Local address is null");
        Object object = this.localLock;
        synchronized (object) {
            remote = SshdSocketAddress.removeByOptionalWildcardAddress(this.localToRemote, local);
            bound = SshdSocketAddress.removeByOptionalWildcardAddress(this.boundLocals, local);
        }
        this.unbindLocalForwarding(local, remote, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindLocalForwarding(SshdSocketAddress local, SshdSocketAddress remote, InetSocketAddress bound) throws IOException {
        if (bound != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("unbindLocalForwarding({} => {}) unbind {}", local, remote, bound);
            }
            SshdSocketAddress boundAddress = new SshdSocketAddress(bound);
            try {
                this.signalTearingDownExplicitTunnel(boundAddress, true, remote);
            }
            finally {
                try {
                    this.localAcceptor.unbind(bound);
                }
                catch (RuntimeException e2) {
                    this.signalTornDownExplicitTunnel(boundAddress, true, remote, e2);
                    throw e2;
                }
            }
            this.signalTornDownExplicitTunnel(boundAddress, true, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("unbindLocalForwarding({} => {}) no mapping({}) or acceptor({})", local, remote, bound, this.localAcceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        int port2;
        Objects.requireNonNull(local, "Local address is null");
        Objects.requireNonNull(remote, "Remote address is null");
        String remoteHost2 = remote.getHostName();
        int remotePort2 = remote.getPort();
        Session session2 = this.getSession();
        Buffer buffer = session2.createBuffer((byte)80, remoteHost2.length() + 64);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remoteHost2);
        buffer.putUInt(remotePort2);
        Duration timeout2 = CoreModuleProperties.FORWARD_REQUEST_TIMEOUT.getRequired(session2);
        this.signalEstablishingExplicitTunnel(local, remote, false);
        try {
            Buffer result2 = session2.request("tcpip-forward", buffer, timeout2);
            if (result2 == null) {
                throw new SshException("Tcpip forwarding request denied by server");
            }
            port2 = remotePort2 == 0 ? result2.getInt() : remote.getPort();
            Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
            synchronized (map2) {
                SshdSocketAddress prev = this.remoteToLocal.get(port2);
                if (prev != null) {
                    throw new IOException("Multiple remote port forwarding bindings on port=" + port2 + ": current=" + remote + ", previous=" + prev);
                }
                this.remoteToLocal.put(port2, local);
            }
        }
        catch (IOException | RuntimeException e2) {
            try {
                this.stopRemotePortForwarding(remote);
            }
            catch (IOException | RuntimeException err) {
                e2.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, null, e2);
            throw e2;
        }
        try {
            SshdSocketAddress bound = new SshdSocketAddress(remoteHost2, port2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startRemotePortForwarding({} -> {}): {}", remote, local, bound);
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, bound, null);
            return bound;
        }
        catch (IOException | RuntimeException e3) {
            this.stopRemotePortForwarding(remote);
            throw e3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        SshdSocketAddress bound;
        int port2 = remote.getPort();
        Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
        synchronized (map2) {
            bound = this.remoteToLocal.remove(port2);
        }
        if (bound != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding({}) cancel forwarding to {}", (Object)remote, (Object)bound);
            }
            String remoteHost2 = remote.getHostName();
            Session session2 = this.getSession();
            Buffer buffer = session2.createBuffer((byte)80, remoteHost2.length() + 64);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remoteHost2);
            buffer.putUInt(port2);
            this.signalTearingDownExplicitTunnel(bound, false, remote);
            try {
                session2.writePacket(buffer);
            }
            catch (IOException | RuntimeException e2) {
                this.signalTornDownExplicitTunnel(bound, false, remote, e2);
                throw e2;
            }
            this.signalTornDownExplicitTunnel(bound, false, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding({}) no binding found", (Object)remote);
        }
    }

    protected void signalTearingDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remote) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTearingDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remote);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal tearing down explicit tunnel for local=" + localForwarding + " on bound=" + boundAddress, t2);
        }
    }

    protected void signalTearingDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress2) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress2);
    }

    protected void signalTornDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress2, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTornDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remoteAddress2, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal torn down explicit tunnel local=" + localForwarding + " on bound=" + boundAddress, t2);
        }
    }

    protected void signalTornDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress2, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress2, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        int port2;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("DefaultForwarder is closed or closing: " + this.state);
        }
        SocksProxy proxy = null;
        InetSocketAddress bound = null;
        this.signalEstablishingDynamicTunnel(local);
        try {
            bound = this.doBind(local, this.getDynamicIoAcceptor());
            port2 = bound.getPort();
            Object object = this.dynamicLock;
            synchronized (object) {
                SocksProxy prevProxy = this.dynamicLocal.get(port2);
                if (prevProxy != null) {
                    throw new IOException("Multiple dynamic port mappings found for port=" + port2 + ": current=" + proxy + ", previous=" + prevProxy);
                }
                InetSocketAddress prevBound = this.boundDynamic.get(port2);
                if (prevBound != null) {
                    throw new IOException("Multiple dynamic port bindings found for port=" + port2 + ": current=" + bound + ", previous=" + prevBound);
                }
                proxy = new SocksProxy(this.service);
                this.dynamicLocal.put(port2, proxy);
                this.boundDynamic.put(port2, bound);
            }
        }
        catch (IOException | RuntimeException e2) {
            try {
                this.unbindDynamicForwarding(local, proxy, bound);
            }
            catch (IOException | RuntimeException err) {
                e2.addSuppressed(err);
            }
            this.signalEstablishedDynamicTunnel(local, null, e2);
            throw e2;
        }
        try {
            SshdSocketAddress result2 = new SshdSocketAddress(bound.getHostString(), port2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startDynamicPortForwarding({}): {}", (Object)local, (Object)result2);
            }
            this.signalEstablishedDynamicTunnel(local, result2, null);
            return result2;
        }
        catch (IOException | RuntimeException e3) {
            this.stopDynamicPortForwarding(local);
            throw e3;
        }
    }

    protected void signalEstablishedDynamicTunnel(SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishedDynamicTunnel((PortForwardingEventListener)l, local, boundAddress, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local + " on bound=" + boundAddress, t2);
        }
    }

    protected void signalEstablishedDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedDynamicTunnel(this.getSession(), local, boundAddress, reason);
    }

    protected void signalEstablishingDynamicTunnel(SshdSocketAddress local) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishingDynamicTunnel((PortForwardingEventListener)l, local);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local, t2);
        }
    }

    protected void signalEstablishingDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingDynamicTunnel(this.getSession(), local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SocksProxy proxy;
        int port2 = local.getPort();
        Object object = this.dynamicLock;
        synchronized (object) {
            proxy = this.dynamicLocal.remove(port2);
            bound = this.boundDynamic.remove(port2);
        }
        this.unbindDynamicForwarding(local, proxy, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unbindDynamicForwarding(SshdSocketAddress local, SocksProxy proxy, InetSocketAddress bound) throws IOException {
        block23: {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (bound == null && proxy == null) {
                if (!debugEnabled) return;
                this.log.debug("stopDynamicPortForwarding({}) no binding found", (Object)local);
                return;
            }
            try {
                this.signalTearingDownDynamicTunnel(local);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (proxy != null) {
                            if (debugEnabled) {
                                this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                            }
                            proxy.close(true);
                        }
                        if (bound != null && this.dynamicAcceptor != null) {
                            if (debugEnabled) {
                                this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                            }
                            this.dynamicAcceptor.unbind(bound);
                            throw throwable;
                        }
                        if (!debugEnabled) throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (bound != null && this.dynamicAcceptor != null) {
                            if (debugEnabled) {
                                this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                            }
                            this.dynamicAcceptor.unbind(bound);
                            throw throwable2;
                        }
                        if (!debugEnabled) throw throwable2;
                        this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", local, this.dynamicAcceptor, bound);
                        throw throwable2;
                    }
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", local, this.dynamicAcceptor, bound);
                    throw throwable;
                }
                catch (RuntimeException e2) {
                    this.signalTornDownDynamicTunnel(local, e2);
                    throw e2;
                }
            }
            try {
                try {
                    if (proxy != null) {
                        if (debugEnabled) {
                            this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                        }
                        proxy.close(true);
                    }
                    if (bound != null && this.dynamicAcceptor != null) {
                        if (debugEnabled) {
                            this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                        }
                        this.dynamicAcceptor.unbind(bound);
                        break block23;
                    }
                    if (!debugEnabled) break block23;
                }
                catch (Throwable throwable) {
                    if (bound != null && this.dynamicAcceptor != null) {
                        if (debugEnabled) {
                            this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                        }
                        this.dynamicAcceptor.unbind(bound);
                        throw throwable;
                    }
                    if (!debugEnabled) throw throwable;
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", local, this.dynamicAcceptor, bound);
                    throw throwable;
                }
                this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", local, this.dynamicAcceptor, bound);
            }
            catch (RuntimeException e3) {
                this.signalTornDownDynamicTunnel(local, e3);
                throw e3;
            }
        }
        this.signalTornDownDynamicTunnel(local, null);
    }

    protected void signalTearingDownDynamicTunnel(SshdSocketAddress address) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTearingDownDynamicTunnel((PortForwardingEventListener)l, address);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal tearing down dynamic tunnel for address=" + address, t2);
        }
    }

    protected void signalTearingDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownDynamicTunnel(this.getSession(), address);
    }

    protected void signalTornDownDynamicTunnel(SshdSocketAddress address, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalTornDownDynamicTunnel((PortForwardingEventListener)l, address, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal torn down dynamic tunnel for address=" + address, t2);
        }
    }

    protected void signalTornDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownDynamicTunnel(this.getSession(), address, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int remotePort2) {
        Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
        synchronized (map2) {
            return this.remoteToLocal.get(remotePort2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        SshdSocketAddress result2;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        Session session2 = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No factory manager");
        TcpForwardingFilter filter2 = manager.getTcpForwardingFilter();
        try {
            if (filter2 == null || !filter2.canListen(local, session2)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("localPortForwardingRequested({})[{}][haveFilter={}] rejected", session2, local, filter2 != null);
                }
                return null;
            }
        }
        catch (Error e2) {
            this.warn("localPortForwardingRequested({})[{}] failed ({}) to consult forwarding filter: {}", session2, local, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            throw new RuntimeSshException(e2);
        }
        this.signalEstablishingExplicitTunnel(local, null, true);
        try {
            boolean added;
            InetSocketAddress bound = this.doBind(local, this.getLocalIoAcceptor());
            result2 = new SshdSocketAddress(bound);
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested({}): {}", (Object)local, (Object)result2);
            }
            LocalForwardingEntry localEntry = new LocalForwardingEntry(local, result2);
            Set<LocalForwardingEntry> set2 = this.localForwards;
            synchronized (set2) {
                added = this.localForwards.add(localEntry);
            }
            if (!added) {
                throw new IOException("Failed to add local port forwarding entry for " + local + " -> " + result2);
            }
        }
        catch (IOException | Error | RuntimeException e3) {
            try {
                this.localPortForwardingCancelled(local);
            }
            catch (IOException | Error | RuntimeException err) {
                e3.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, null, true, null, e3);
            throw e3;
        }
        this.signalEstablishedExplicitTunnel(local, null, true, result2, null);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        LocalForwardingEntry entry;
        Set<LocalForwardingEntry> set2 = this.localForwards;
        synchronized (set2) {
            entry = LocalForwardingEntry.findMatchingEntry(local.getHostName(), local.getPort(), this.localForwards);
            if (entry != null) {
                this.localForwards.remove(entry);
            }
        }
        if (entry != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled({}) unbind {}", (Object)local, (Object)entry);
            }
            SshdSocketAddress reportedBoundAddress = entry.getCombinedBoundAddress();
            this.signalTearingDownExplicitTunnel(reportedBoundAddress, true, null);
            SshdSocketAddress boundAddress = entry.getBoundAddress();
            try {
                this.localAcceptor.unbind(boundAddress.toInetSocketAddress());
            }
            catch (Error | RuntimeException e2) {
                this.signalTornDownExplicitTunnel(reportedBoundAddress, true, null, e2);
                throw e2;
            }
            this.signalTornDownExplicitTunnel(reportedBoundAddress, true, null, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled({}) no match/acceptor: {}", (Object)local, (Object)entry);
        }
    }

    protected void signalEstablishingExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishingExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal establishing explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding, t2);
        }
    }

    protected void signalEstablishingExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingExplicitTunnel(this.getSession(), local, remote, localForwarding);
    }

    protected void signalEstablishedExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller(l -> {
                this.signalEstablishedExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding, boundAddress, reason);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw new IOException("Failed (" + t2.getClass().getSimpleName() + ") to signal established explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding + ", bound=" + boundAddress, t2);
        }
    }

    protected void signalEstablishedExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedExplicitTunnel(this.getSession(), local, remote, localForwarding, boundAddress, reason);
    }

    protected void invokePortEventListenerSignaller(Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        Throwable e2;
        Throwable err = null;
        try {
            this.invokePortEventListenerSignallerListeners(this.getDefaultListeners(), invoker);
        }
        catch (Throwable t2) {
            e2 = ExceptionUtils.peelException(t2);
            err = ExceptionUtils.accumulateException(err, e2);
        }
        try {
            this.invokePortEventListenerSignallerHolders(this.managersHolder, invoker);
        }
        catch (Throwable t3) {
            e2 = ExceptionUtils.peelException(t3);
            err = ExceptionUtils.accumulateException(err, e2);
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerListeners(Collection<? extends PortForwardingEventListener> listeners, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(listeners)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListener portForwardingEventListener : listeners) {
            if (portForwardingEventListener == null) continue;
            try {
                invoker.invoke(portForwardingEventListener);
            }
            catch (Throwable t2) {
                Throwable e2 = ExceptionUtils.peelException(t2);
                err = ExceptionUtils.accumulateException(err, e2);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerHolders(Collection<? extends PortForwardingEventListenerManager> holders, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(holders)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListenerManager portForwardingEventListenerManager : holders) {
            try {
                PortForwardingEventListener listener = portForwardingEventListenerManager.getPortForwardingEventListenerProxy();
                if (listener != null) {
                    invoker.invoke(listener);
                }
            }
            catch (Throwable t2) {
                Throwable e2 = ExceptionUtils.peelException(t2);
                err = ExceptionUtils.accumulateException(err, e2);
            }
            if (!(portForwardingEventListenerManager instanceof PortForwardingEventListenerManagerHolder)) continue;
            try {
                this.invokePortEventListenerSignallerHolders(((PortForwardingEventListenerManagerHolder)((Object)portForwardingEventListenerManager)).getRegisteredManagers(), invoker);
            }
            catch (Throwable t3) {
                Throwable e2 = ExceptionUtils.peelException(t3);
                err = ExceptionUtils.accumulateException(err, e2);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.dynamicLocal.values()).close(this.localAcceptor).close(this.dynamicAcceptor).build();
    }

    @Override
    protected void preClose() {
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected IoAcceptor createIoAcceptor(Factory<? extends IoHandler> handlerFactory) {
        Session session2 = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No factory manager");
        IoServiceFactory factory2 = Objects.requireNonNull(manager.getIoServiceFactory(), "No I/O service factory");
        IoHandler handler2 = handlerFactory.create();
        return factory2.createAcceptor(handler2);
    }

    protected IoAcceptor getLocalIoAcceptor() {
        if (this.localAcceptor == null) {
            this.localAcceptor = this.createIoAcceptor(this.staticIoHandlerFactory);
        }
        return this.localAcceptor;
    }

    protected IoAcceptor getDynamicIoAcceptor() {
        if (this.dynamicAcceptor == null) {
            this.dynamicAcceptor = this.createIoAcceptor(this.socksProxyIoHandlerFactory);
        }
        return this.dynamicAcceptor;
    }

    protected InetSocketAddress doBind(SshdSocketAddress address, IoAcceptor acceptor) throws IOException {
        Set<SocketAddress> before = acceptor.getBoundAddresses();
        try {
            InetSocketAddress bindAddress = address.toInetSocketAddress();
            acceptor.bind(bindAddress);
            Set<SocketAddress> after = acceptor.getBoundAddresses();
            if (GenericUtils.size(after) > 0) {
                after.removeAll(before);
            }
            if (GenericUtils.isEmpty(after)) {
                throw new IOException("Error binding to " + address + "[" + bindAddress + "]: no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address + "[" + bindAddress + "]");
            }
            InetSocketAddress boundAddress = (InetSocketAddress)GenericUtils.head(after);
            return boundAddress;
        }
        catch (IOException bindErr) {
            Set<SocketAddress> after = acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(after)) {
                this.close();
            }
            throw bindErr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SshdSocketAddress> getBoundLocalPortForwards(int port2) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : this.localToRemote.keySet().stream().filter(k2 -> k2.getPort() == port2).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocalPortForwardingStartedForPort(int port2) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.keySet().stream().anyMatch(e2 -> e2.getPort() == port2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<SshdSocketAddress, SshdSocketAddress>> getLocalForwardsBindings() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : (List)this.localToRemote.entrySet().stream().map(e2 -> new AbstractMap.SimpleImmutableEntry<SshdSocketAddress, SshdSocketAddress>((SshdSocketAddress)e2.getKey(), (SshdSocketAddress)e2.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.localToRemote.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SshdSocketAddress> getStartedLocalPortForwards() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : new ArrayList<SshdSocketAddress>(this.localToRemote.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings() {
        Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
        synchronized (map2) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyList() : (List)this.remoteToLocal.entrySet().stream().map(e2 -> new AbstractMap.SimpleImmutableEntry<Integer, SshdSocketAddress>((Integer)e2.getKey(), (SshdSocketAddress)e2.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.remoteToLocal.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshdSocketAddress getBoundRemotePortForward(int port2) {
        ValidateUtils.checkTrue(port2 > 0, "Invalid remote port: %d", port2);
        Integer portKey = port2;
        Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
        synchronized (map2) {
            return this.remoteToLocal.get(portKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet<Integer> getStartedRemotePortForwards() {
        Map<Integer, SshdSocketAddress> map2 = this.remoteToLocal;
        synchronized (map2) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(this.remoteToLocal.keySet());
        }
    }

    class StaticIoHandler
    implements IoHandler {
        private final AtomicLong messagesCounter = new AtomicLong(0L);

        StaticIoHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionCreated(IoSession session2) throws Exception {
            SshdSocketAddress remote;
            InetSocketAddress localAddress2 = (InetSocketAddress)session2.getLocalAddress();
            SshdSocketAddress local = new SshdSocketAddress(localAddress2);
            Object object = DefaultForwarder.this.localLock;
            synchronized (object) {
                remote = (SshdSocketAddress)SshdSocketAddress.findByOptionalWildcardAddress(DefaultForwarder.this.localToRemote, local);
            }
            TcpipClientChannel.Type channelType = remote == null ? TcpipClientChannel.Type.Forwarded : TcpipClientChannel.Type.Direct;
            TcpipClientChannel channel2 = new TcpipClientChannel(channelType, session2, remote);
            channel2.setStreaming(StreamingChannel.Streaming.Async);
            session2.setAttribute(TcpipClientChannel.class, channel2);
            session2.suspendRead();
            if (channelType == TcpipClientChannel.Type.Forwarded) {
                SocketAddress accepted = session2.getAcceptanceAddress();
                LocalForwardingEntry localEntry = null;
                if (accepted instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)accepted;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    Set set2 = DefaultForwarder.this.localForwards;
                    synchronized (set2) {
                        localEntry = LocalForwardingEntry.findMatchingEntry(inetSocketAddress.getHostString(), inetAddress.isAnyLocalAddress(), local.getPort(), DefaultForwarder.this.localForwards);
                    }
                }
                if (localEntry != null) {
                    if (DefaultForwarder.this.log.isDebugEnabled()) {
                        DefaultForwarder.this.log.debug("sessionCreated({})[local={}, remote={}, accepted={}] localEntry={}", session2, local, remote, accepted, localEntry);
                    }
                    channel2.updateLocalForwardingEntry(localEntry);
                } else {
                    DefaultForwarder.this.log.warn("sessionCreated({})[local={}, remote={}] cannot locate original local entry for accepted={}", session2, local, remote, accepted);
                }
            } else if (DefaultForwarder.this.log.isDebugEnabled()) {
                DefaultForwarder.this.log.debug("sessionCreated({}) local={}, remote={}", session2, local, remote);
            }
            DefaultForwarder.this.service.registerChannel(channel2);
            channel2.open().addListener(future -> {
                session2.resumeRead();
                Throwable t2 = future.getException();
                if (t2 != null) {
                    DefaultForwarder.this.warn("Failed ({}) to open channel for session={}: {}", t2.getClass().getSimpleName(), session2, t2.getMessage(), t2);
                    DefaultForwarder.this.service.unregisterChannel(channel2);
                    channel2.close(false);
                }
            });
        }

        @Override
        public void sessionClosed(IoSession session2) throws Exception {
            TcpipClientChannel channel2 = (TcpipClientChannel)session2.removeAttribute(TcpipClientChannel.class);
            Throwable cause = (Throwable)session2.removeAttribute(TcpipForwardingExceptionMarker.class);
            if (DefaultForwarder.this.log.isDebugEnabled()) {
                DefaultForwarder.this.log.debug("sessionClosed({}) closing channel={} after {} messages - cause={}", session2, channel2, this.messagesCounter, cause == null ? null : cause.getClass().getSimpleName());
            }
            if (channel2 == null) {
                return;
            }
            channel2.close(cause != null);
        }

        @Override
        public void messageReceived(IoSession session2, Readable message) throws Exception {
            TcpipClientChannel channel2 = (TcpipClientChannel)session2.getAttribute(TcpipClientChannel.class);
            long totalMessages = this.messagesCounter.incrementAndGet();
            ByteArrayBuffer buffer = new ByteArrayBuffer(message.available(), false);
            buffer.putBuffer(message);
            if (DefaultForwarder.this.log.isTraceEnabled()) {
                DefaultForwarder.this.log.trace("messageReceived({}) channel={}, count={}, handle len={}", session2, channel2, totalMessages, message.available());
            }
            session2.suspendRead();
            ThreadUtils.runAsInternal(() -> channel2.getAsyncIn().writeBuffer(buffer).addListener(f2 -> {
                session2.resumeRead();
                Throwable e2 = f2.getException();
                if (e2 != null) {
                    try {
                        this.exceptionCaught(session2, e2);
                    }
                    catch (Exception err) {
                        DefaultForwarder.this.warn("messageReceived({}) failed ({}) to signal {}[{}] on channel={}: {}", session2, err.getClass().getSimpleName(), e2.getClass().getSimpleName(), e2.getMessage(), channel2, err.getMessage(), err);
                    }
                } else if (DefaultForwarder.this.log.isTraceEnabled()) {
                    DefaultForwarder.this.log.trace("messageReceived({}) channel={} message={} forwarded", session2, channel2, totalMessages);
                }
            }));
        }

        @Override
        public void exceptionCaught(IoSession session2, Throwable cause) throws Exception {
            session2.setAttribute(TcpipForwardingExceptionMarker.class, cause);
            DefaultForwarder.this.log.warn("exceptionCaught({}) {}: {}", session2, cause.getClass().getSimpleName(), cause.getMessage(), cause);
            session2.close(true);
        }
    }
}

