/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class LocalForwardingEntry {
    private final SshdSocketAddress local;
    private final SshdSocketAddress bound;
    private final SshdSocketAddress combined;

    public LocalForwardingEntry(SshdSocketAddress local, InetSocketAddress bound) {
        this(local, new SshdSocketAddress(bound));
    }

    public LocalForwardingEntry(SshdSocketAddress local, SshdSocketAddress bound) {
        this.local = Objects.requireNonNull(local, "No local address provided");
        this.bound = Objects.requireNonNull(bound, "No bound address provided");
        this.combined = LocalForwardingEntry.resolveCombinedBoundAddress(local, bound);
    }

    public SshdSocketAddress getLocalAddress() {
        return this.local;
    }

    public SshdSocketAddress getBoundAddress() {
        return this.bound;
    }

    public SshdSocketAddress getCombinedBoundAddress() {
        return this.combined;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        LocalForwardingEntry other = (LocalForwardingEntry)o;
        return Objects.equals(this.getCombinedBoundAddress(), other.getCombinedBoundAddress());
    }

    public int hashCode() {
        return Objects.hashCode(this.getCombinedBoundAddress());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", bound=" + this.getBoundAddress() + ", combined=" + this.getCombinedBoundAddress() + "]";
    }

    public static SshdSocketAddress resolveCombinedBoundAddress(SshdSocketAddress local, SshdSocketAddress bound) {
        int localPort2 = local.getPort();
        int boundPort = bound.getPort();
        if (localPort2 > 0 && localPort2 != boundPort) {
            throw new IllegalArgumentException("Mismatched ports for local (" + local + ") vs. bound (" + bound + ") entry");
        }
        if (Objects.equals(local, bound)) {
            return local;
        }
        String localName = local.getHostName();
        boolean wildcardLocal = SshdSocketAddress.isWildcardAddress(localName);
        if (wildcardLocal) {
            return bound;
        }
        if (localPort2 > 0) {
            return local;
        }
        return new SshdSocketAddress(localName, boundPort);
    }

    public static LocalForwardingEntry findMatchingEntry(String host2, int port2, Collection<? extends LocalForwardingEntry> entries2) {
        return LocalForwardingEntry.findMatchingEntry(host2, SshdSocketAddress.isWildcardAddress(host2), port2, entries2);
    }

    public static LocalForwardingEntry findMatchingEntry(String host2, boolean anyLocalAddress, int port2, Collection<? extends LocalForwardingEntry> entries2) {
        if (port2 <= 0 || GenericUtils.isEmpty(entries2)) {
            return null;
        }
        if (GenericUtils.isEmpty(host2) && !anyLocalAddress) {
            return null;
        }
        LocalForwardingEntry candidate = null;
        for (LocalForwardingEntry localForwardingEntry : entries2) {
            SshdSocketAddress bound = localForwardingEntry.getBoundAddress();
            if (port2 != bound.getPort()) continue;
            String boundName = bound.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(host2, boundName, false)) {
                return localForwardingEntry;
            }
            SshdSocketAddress local = localForwardingEntry.getLocalAddress();
            String localName = local.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(host2, localName, false)) {
                return localForwardingEntry;
            }
            if (SshdSocketAddress.isLoopbackAlias(host2, boundName) || SshdSocketAddress.isLoopbackAlias(host2, localName)) {
                return localForwardingEntry;
            }
            if (!anyLocalAddress) continue;
            if (candidate != null) {
                throw new IllegalStateException("Multiple candidate matches for " + host2 + "@" + port2 + ": " + candidate + ", " + localForwardingEntry);
            }
            candidate = localForwardingEntry;
        }
        if (anyLocalAddress) {
            return candidate;
        }
        return null;
    }
}

