/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class SocksProxy
extends AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map<IoSession, Proxy> proxies = new ConcurrentHashMap<IoSession, Proxy>();

    public SocksProxy(ConnectionService service) {
        this.service = service;
    }

    @Override
    public void sessionCreated(IoSession session2) throws Exception {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed: " + this.state);
        }
    }

    @Override
    public void sessionClosed(IoSession session2) throws Exception {
        Proxy proxy = this.proxies.remove(session2);
        if (proxy != null) {
            proxy.close();
        }
    }

    @Override
    public void messageReceived(IoSession session2, Readable message) throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        Proxy proxy = this.proxies.get(session2);
        if (proxy == null) {
            int version2 = buffer.getUByte();
            if (version2 == 4) {
                proxy = new Socks4(session2);
            } else if (version2 == 5) {
                proxy = new Socks5(session2);
            } else {
                throw new IllegalStateException("Unsupported version: " + version2);
            }
            proxy.onMessage(buffer);
            this.proxies.put(session2, proxy);
        } else {
            proxy.onMessage(buffer);
        }
    }

    @Override
    public void exceptionCaught(IoSession session2, Throwable cause) throws Exception {
        this.log.warn("Exception caught, closing socks proxy", cause);
        session2.close(false);
    }

    public static abstract class Proxy
    implements Closeable {
        protected IoSession session;
        protected TcpipClientChannel channel;

        protected Proxy(IoSession session2) {
            this.session = session2;
        }

        protected void onMessage(Buffer buffer) throws IOException {
            this.session.suspendRead();
            ThreadUtils.runAsInternal(this.channel.getAsyncIn(), out2 -> out2.writeBuffer(buffer).addListener(f2 -> this.session.resumeRead()));
        }

        @Override
        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close(false);
            }
        }

        protected int getUByte(Buffer buffer) {
            return buffer.getUByte();
        }

        protected int getUShort(Buffer buffer) {
            return (this.getUByte(buffer) << 8) + this.getUByte(buffer);
        }
    }

    public class Socks4
    extends Proxy {
        public Socks4(IoSession session2) {
            super(session2);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            if (this.channel == null) {
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int port2 = this.getUShort(buffer);
                String host2 = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                String userId = this.getNTString(buffer);
                if (host2.startsWith("0.0.0.")) {
                    host2 = this.getNTString(buffer);
                }
                if (SocksProxy.this.log.isDebugEnabled()) {
                    SocksProxy.this.log.debug("Received socks4 connection request for {} to {}:{}", userId, host2, port2);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host2, port2);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(this::onChannelOpened);
            } else {
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            this.session.resumeRead();
            ByteArrayBuffer buffer = new ByteArrayBuffer(64, false);
            ((Buffer)buffer).putByte((byte)0);
            Throwable t2 = future.getException();
            if (t2 != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                ((Buffer)buffer).putByte((byte)91);
            } else {
                ((Buffer)buffer).putByte((byte)90);
            }
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            try {
                this.session.writeBuffer(buffer);
            }
            catch (IOException e2) {
                SocksProxy.this.log.error("Failed ({}) to send channel open packet for {}: {}", e2.getClass().getSimpleName(), this.channel, e2.getMessage());
                throw new IllegalStateException("Failed to send packet", e2);
            }
        }

        protected String getNTString(Buffer buffer) {
            StringBuilder sb = new StringBuilder();
            char c2 = (char)this.getUByte(buffer);
            while (c2 != '\u0000') {
                sb.append(c2);
                c2 = (char)this.getUByte(buffer);
            }
            return sb.toString();
        }
    }

    public class Socks5
    extends Proxy {
        private byte[] authMethods;
        private Buffer response;

        public Socks5(IoSession session2) {
            super(session2);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            boolean debugEnabled = SocksProxy.this.log.isDebugEnabled();
            if (this.authMethods == null) {
                int nbAuthMethods = this.getUByte(buffer);
                this.authMethods = new byte[nbAuthMethods];
                buffer.getRawBytes(this.authMethods);
                boolean foundNoAuth = false;
                for (int i2 = 0; i2 < nbAuthMethods; ++i2) {
                    foundNoAuth |= this.authMethods[i2] == 0;
                }
                buffer = new ByteArrayBuffer(8, false);
                buffer.putByte((byte)5);
                buffer.putByte((byte)(foundNoAuth ? 0 : 255));
                this.session.writeBuffer(buffer);
                if (!foundNoAuth) {
                    throw new IllegalStateException("Received socks5 greeting without NoAuth method");
                }
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 greeting");
                }
            } else if (this.channel == null) {
                String host2;
                int type2;
                this.response = buffer;
                int version2 = this.getUByte(buffer);
                if (version2 != 5) {
                    throw new IllegalStateException("Unexpected version: " + version2);
                }
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int res = buffer.getUByte();
                if (res != 0 && debugEnabled) {
                    SocksProxy.this.log.debug("No zero reserved value: {}", (Object)res);
                }
                if ((type2 = buffer.getUByte()) == 1) {
                    host2 = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                } else if (type2 == 3) {
                    host2 = this.getBLString(buffer);
                } else if (type2 == 4) {
                    host2 = Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer));
                } else {
                    throw new IllegalStateException("Unsupported address type: " + type2);
                }
                int port2 = this.getUShort(buffer);
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection request to {}:{}", (Object)host2, (Object)port2);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host2, port2);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(this::onChannelOpened);
            } else {
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection message");
                }
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            this.session.resumeRead();
            int wpos = this.response.wpos();
            this.response.rpos(0);
            this.response.wpos(1);
            Throwable t2 = future.getException();
            if (t2 != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                this.response.putByte((byte)1);
            } else {
                this.response.putByte((byte)0);
            }
            this.response.wpos(wpos);
            try {
                this.session.writeBuffer(this.response);
            }
            catch (IOException e2) {
                SocksProxy.this.log.error("Failed ({}) to send channel open response for {}: {}", e2.getClass().getSimpleName(), this.channel, e2.getMessage());
                throw new IllegalStateException("Failed to send packet", e2);
            }
        }

        protected String getBLString(Buffer buffer) {
            int length = this.getUByte(buffer);
            StringBuilder sb = new StringBuilder(length);
            for (int i2 = 0; i2 < length; ++i2) {
                sb.append((char)this.getUByte(buffer));
            }
            return sb.toString();
        }
    }
}

