/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.forward.ChannelToPortHandler;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipClientChannel
extends AbstractClientChannel
implements ForwardingTunnelEndpointsProvider {
    protected final SshdSocketAddress remote;
    protected final ChannelToPortHandler port;
    protected SshdSocketAddress localEntry;
    private final Type typeEnum;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;

    public TcpipClientChannel(Type type2, IoSession serverSession, SshdSocketAddress remote) {
        super(Objects.requireNonNull(type2, "No type specified").getName());
        this.typeEnum = type2;
        this.port = this.createChannelToPortHandler(Objects.requireNonNull(serverSession, "No server session provided"));
        this.localEntry = new SshdSocketAddress((InetSocketAddress)serverSession.getLocalAddress());
        this.remote = remote;
    }

    protected ChannelToPortHandler createChannelToPortHandler(IoSession session2) {
        return new ChannelToPortHandler(session2, this);
    }

    public Type getTcpipChannelType() {
        return this.typeEnum;
    }

    public void updateLocalForwardingEntry(LocalForwardingEntry entry) {
        Objects.requireNonNull(entry, "No local forwarding entry provided");
        this.localEntry = new SshdSocketAddress(entry.getLocalAddress().getHostName(), entry.getBoundAddress().getPort());
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        SshdSocketAddress dst;
        InetSocketAddress src;
        IoSession portSession = this.port.getPortSession();
        InetSocketAddress loc = (InetSocketAddress)portSession.getLocalAddress();
        Type openType = this.getTcpipChannelType();
        switch (openType.ordinal()) {
            case 0: {
                src = (InetSocketAddress)portSession.getRemoteAddress();
                dst = this.remote;
                this.tunnelEntrance = new SshdSocketAddress(loc.getHostString(), loc.getPort());
                this.tunnelExit = new SshdSocketAddress(dst.getHostName(), dst.getPort());
                break;
            }
            case 1: {
                src = (InetSocketAddress)portSession.getRemoteAddress();
                dst = this.localEntry;
                this.tunnelEntrance = new SshdSocketAddress(src.getHostString(), src.getPort());
                this.tunnelExit = new SshdSocketAddress(loc.getHostString(), loc.getPort());
                break;
            }
            default: {
                throw new SshException("Unknown client channel type: " + openType);
            }
        }
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(src, this.futureLock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) send SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session2 = this.getSession();
        String srcHost = src.getHostString();
        String dstHost = dst.getHostName();
        LocalWindow wLocal = this.getLocalWindow();
        String type2 = this.getChannelType();
        Buffer buffer = session2.createBuffer((byte)90, type2.length() + srcHost.length() + dstHost.length() + 64);
        buffer.putString(type2);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(wLocal.getSize());
        buffer.putUInt(wLocal.getPacketSize());
        buffer.putString(dstHost);
        buffer.putUInt(dst.getPort());
        buffer.putString(srcHost);
        buffer.putUInt(src.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (this.streaming == StreamingChannel.Streaming.Async) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    DefaultCloseFuture result2 = new DefaultCloseFuture(TcpipClientChannel.this.getChannelId(), this.futureLock);
                    CloseFuture packetsWritten = super.doCloseGracefully();
                    packetsWritten.addListener(p -> {
                        try {
                            IoWriteFuture eofSent = TcpipClientChannel.this.sendEof();
                            if (eofSent != null) {
                                eofSent.addListener(f2 -> result2.setClosed());
                                return;
                            }
                        }
                        catch (Exception e2) {
                            TcpipClientChannel.this.getSession().exceptionCaught(e2);
                        }
                        result2.setClosed();
                    });
                    return result2;
                }
            };
            this.asyncOut = new ChannelAsyncInputStream(this);
        } else {
            this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.port.getPortSession(), super.getInnerCloseable()).build();
    }

    @Override
    protected void doWriteData(byte[] data2, int off, long len2) throws IOException {
        this.port.sendToPort((byte)94, data2, off, len2);
    }

    @Override
    protected void doWriteExtendedData(byte[] data2, int off, long len2) throws IOException {
        throw new UnsupportedOperationException(this.getChannelType() + " Tcpip channel does not support extended data");
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        this.port.handleEof();
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public static enum Type implements NamedResource
    {
        Direct("direct-tcpip"),
        Forwarded("forwarded-tcpip");

        public static final Set<Type> VALUES;
        private final String channelType;

        private Type(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public String getName() {
            return this.channelType;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(Type.class));
        }
    }
}

