/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.HasException;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;

public class GlobalRequestFuture
extends DefaultSshFuture<GlobalRequestFuture>
implements HasException,
SshFutureListener<IoWriteFuture> {
    private final ReplyHandler handler;
    private long sequenceNumber;

    public GlobalRequestFuture(String request2) {
        this(request2, null);
    }

    public GlobalRequestFuture(String request2, ReplyHandler handler2) {
        super(request2, null);
        this.handler = handler2;
    }

    @Override
    public String getId() {
        return (String)super.getId();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long number) {
        if (number < 0L || (number & 0xFFFFFFFFL) != number) {
            throw new IllegalArgumentException("Invalid sequence number " + number);
        }
        this.sequenceNumber = number;
    }

    public ReplyHandler getHandler() {
        return this.handler;
    }

    public Buffer getBuffer() {
        Object value2 = this.getValue();
        if (value2 instanceof Buffer) {
            return (Buffer)value2;
        }
        return null;
    }

    @Override
    public Throwable getException() {
        Object value2 = this.getValue();
        if (value2 instanceof Throwable) {
            return (Throwable)value2;
        }
        return null;
    }

    @Override
    public void operationComplete(IoWriteFuture future) {
        if (!future.isWritten()) {
            Throwable ioe = future.getException();
            if (ioe != null) {
                this.setValue(ioe);
            } else {
                this.setValue(new SshException("Could not write global request " + this.getId() + " seqNo=" + this.getSequenceNumber()));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[seqNo=" + this.sequenceNumber + ']';
    }

    @FunctionalInterface
    public static interface ReplyHandler {
        public void accept(int var1, Buffer var2);
    }
}

