/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.global;

import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;

public abstract class AbstractOpenSshHostKeysHandler
extends AbstractConnectionServiceRequestHandler {
    private final String request;
    private final BufferPublicKeyParser<? extends PublicKey> parser;
    private boolean ignoreInvalidKeys;

    protected AbstractOpenSshHostKeysHandler(String request2) {
        this(request2, BufferPublicKeyParser.DEFAULT);
    }

    protected AbstractOpenSshHostKeysHandler(String request2, BufferPublicKeyParser<? extends PublicKey> parser) {
        this.request = ValidateUtils.checkNotNullAndNotEmpty(request2, "No request identifier");
        this.parser = Objects.requireNonNull(parser, "No public keys extractor");
    }

    public final String getRequestName() {
        return this.request;
    }

    public BufferPublicKeyParser<? extends PublicKey> getPublicKeysParser() {
        return this.parser;
    }

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request2, boolean wantReply, Buffer buffer) throws Exception {
        String expected = this.getRequestName();
        if (!expected.equals(request2)) {
            return super.process(connectionService, request2, wantReply, buffer);
        }
        LinkedList<PublicKey> keys2 = new LinkedList<PublicKey>();
        BufferPublicKeyParser<? extends PublicKey> p = this.getPublicKeysParser();
        if (p != null) {
            boolean debugEnabled = this.log.isDebugEnabled();
            while (buffer.available() > 0) {
                PublicKey key2;
                block7: {
                    key2 = null;
                    try {
                        key2 = buffer.getPublicKey(p);
                    }
                    catch (SshException e2) {
                        if (!this.isIgnoreInvalidKeys()) {
                            throw e2;
                        }
                        if (!this.log.isTraceEnabled()) break block7;
                        this.log.trace("process({})[{}] received an unsupported key", connectionService, request2, e2);
                    }
                }
                if (key2 == null) continue;
                if (debugEnabled) {
                    this.log.debug("process({})[{}] key type={}, fingerprint={}", connectionService, request2, KeyUtils.getKeyType(key2), KeyUtils.getFingerPrint(key2));
                }
                keys2.add(key2);
            }
        }
        return this.handleHostKeys((Session)connectionService.getSession(), (Collection<? extends PublicKey>)keys2, wantReply, buffer);
    }

    protected void setIgnoreInvalidKeys(boolean ignore) {
        this.ignoreInvalidKeys = ignore;
    }

    protected boolean isIgnoreInvalidKeys() {
        return this.ignoreInvalidKeys;
    }

    protected abstract RequestHandler.Result handleHostKeys(Session var1, Collection<? extends PublicKey> var2, boolean var3, Buffer var4) throws Exception;

    public String toString() {
        return this.getRequestName();
    }
}

