/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.util.ReflectionUtils;

public enum BuiltinIoServiceFactoryFactories implements NamedFactory<IoServiceFactoryFactory>,
OptionalFeature
{
    NIO2(Nio2ServiceFactoryFactory.class),
    MINA("org.apache.sshd.mina.MinaServiceFactoryFactory"),
    NETTY("org.apache.sshd.netty.NettyIoServiceFactoryFactory");

    public static final Set<BuiltinIoServiceFactoryFactories> VALUES;
    private final Class<? extends IoServiceFactoryFactory> factoryClass;
    private final String factoryClassName;

    private BuiltinIoServiceFactoryFactories(Class<? extends IoServiceFactoryFactory> clazz) {
        this.factoryClass = clazz;
        this.factoryClassName = null;
    }

    private BuiltinIoServiceFactoryFactories(String clazz) {
        this.factoryClass = null;
        this.factoryClassName = clazz;
    }

    public final String getFactoryClassName() {
        if (this.factoryClass != null) {
            return this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    public final Class<? extends IoServiceFactoryFactory> getFactoryClass() {
        if (this.factoryClass != null) {
            return this.factoryClass;
        }
        try {
            return Class.forName(this.factoryClassName, true, BuiltinIoServiceFactoryFactories.class.getClassLoader());
        }
        catch (ClassNotFoundException e2) {
            try {
                return Class.forName(this.factoryClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException(e2);
            }
        }
    }

    @Override
    public final String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public final IoServiceFactoryFactory create() {
        Class<? extends IoServiceFactoryFactory> clazz = this.getFactoryClass();
        try {
            return ReflectionUtils.newInstance(clazz, IoServiceFactoryFactory.class);
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new IllegalStateException(e3);
        }
    }

    @Override
    public boolean isSupported() {
        try {
            return this.getFactoryClass() != null;
        }
        catch (RuntimeException e2) {
            return false;
        }
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryClass(Class<?> clazz) {
        if (clazz == null || !IoServiceFactoryFactory.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIoServiceFactoryFactories f2 : VALUES) {
            if (!f2.isSupported() || !clazz.isAssignableFrom(f2.getFactoryClass())) continue;
            return f2;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIoServiceFactoryFactories.class));
    }
}

