/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private final Nio2ServiceFactory nio2ServiceFactory;
    private int backlog;

    public Nio2Acceptor(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler handler2, AsynchronousChannelGroup group, ExecutorService resumeTasks) {
        super(propertyResolver, handler2, group, resumeTasks);
        this.nio2ServiceFactory = nio2ServiceFactory;
        this.backlog = CoreModuleProperties.SOCKET_BACKLOG.getRequired(propertyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        if (GenericUtils.isEmpty(addresses)) {
            return;
        }
        AsynchronousChannelGroup group = this.getChannelGroup();
        ArrayList<java.io.Closeable> bound = new ArrayList<java.io.Closeable>(addresses.size());
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            for (SocketAddress socketAddress : addresses) {
                if (debugEnabled) {
                    this.log.debug("bind({}) binding to address", (Object)socketAddress);
                }
                try {
                    AsynchronousServerSocketChannel prev;
                    AsynchronousServerSocketChannel asyncChannel = this.openAsynchronousServerSocketChannel(socketAddress, group);
                    java.io.Closeable protector = this.protectInProgressBinding(socketAddress, asyncChannel);
                    bound.add(protector);
                    AsynchronousServerSocketChannel socket = this.setSocketOptions(asyncChannel);
                    socket.bind(socketAddress, this.backlog);
                    SocketAddress local = socket.getLocalAddress();
                    if (debugEnabled) {
                        this.log.debug("bind({}) bound to {}", (Object)socketAddress, (Object)local);
                    }
                    if ((prev = this.channels.put(local, socket)) != null && debugEnabled) {
                        this.log.debug("bind({}) replaced previous channel ({}) for {}", socketAddress, prev.getLocalAddress(), local);
                    }
                    CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> handler2 = ValidateUtils.checkNotNull(this.createSocketCompletionHandler(this.channels, socket), "No completion handler created for address=%s[%s]", socketAddress, local);
                    socket.accept(local, handler2);
                }
                catch (IOException | RuntimeException e2) {
                    this.error("bind({}) - failed ({}) to bind: {}", socketAddress, e2.getClass().getSimpleName(), e2.getMessage(), e2);
                    throw e2;
                }
            }
            bound.clear();
        }
        finally {
            IOException err = IoUtils.closeQuietly(bound);
            if (err != null) {
                throw err;
            }
        }
    }

    protected java.io.Closeable protectInProgressBinding(final SocketAddress address, final AsynchronousServerSocketChannel asyncChannel) {
        final boolean debugEnabled = this.log.isDebugEnabled();
        return new java.io.Closeable(){

            @Override
            public void close() throws IOException {
                block8: {
                    try {
                        try {
                            SocketAddress local = asyncChannel.getLocalAddress();
                            if (local != null) {
                                if (debugEnabled) {
                                    Nio2Acceptor.this.log.debug("protectInProgressBinding({}) remove {} binding", (Object)address, (Object)local);
                                }
                                Nio2Acceptor.this.channels.remove(local);
                            }
                        }
                        finally {
                            if (debugEnabled) {
                                Nio2Acceptor.this.log.debug("protectInProgressBinding({}) auto-close", (Object)address);
                            }
                            asyncChannel.close();
                        }
                    }
                    catch (ClosedChannelException e2) {
                        if (!debugEnabled) break block8;
                        Nio2Acceptor.this.log.debug("protectInProgressBinding(" + address + ") ignore close channel exception", e2);
                    }
                }
            }

            public String toString() {
                return "protectInProgressBinding(" + address + ")";
            }
        };
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousServerSocketChannel.open(group);
    }

    protected CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> createSocketCompletionHandler(Map<SocketAddress, AsynchronousServerSocketChannel> channelsMap, AsynchronousServerSocketChannel socket) throws IOException {
        return new AcceptCompletionHandler(socket);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", (Object)addresses);
        }
        this.unbind(addresses);
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        boolean traceEnabled = this.log.isTraceEnabled();
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel2 = this.channels.remove(socketAddress);
            if (channel2 != null) {
                try {
                    if (traceEnabled) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    channel2.close();
                }
                catch (IOException e2) {
                    this.warn("unbind({}) {} while unbinding channel: {}", socketAddress, e2.getClass().getSimpleName(), e2.getMessage(), e2);
                }
                continue;
            }
            if (!traceEnabled) continue;
            this.log.trace("No active channel to unbind for {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    protected void preClose() {
        this.unbind();
        super.preClose();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        Set<SocketAddress> boundAddresses = this.getBoundAddresses();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (SocketAddress address : boundAddresses) {
            AsynchronousServerSocketChannel asyncChannel = this.channels.remove(address);
            if (asyncChannel == null) continue;
            try {
                asyncChannel.close();
                if (!debugEnabled) continue;
                this.log.debug("doCloseImmediately({}) closed channel", (Object)address);
            }
            catch (IOException e2) {
                if (!debugEnabled) continue;
                this.log.debug("Exception caught while closing channel of " + address, e2);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBoundAddresses() + "]";
    }

    protected class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        protected final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(AsynchronousSocketChannel result2, SocketAddress address) {
            boolean keepAccepting;
            if (!Nio2Acceptor.this.channels.containsKey(address)) {
                if (Nio2Acceptor.this.log.isDebugEnabled()) {
                    Nio2Acceptor.this.log.debug("onCompleted({}) unbound address", (Object)address);
                }
                return;
            }
            Closeable session2 = null;
            Long sessionId = null;
            IoServiceEventListener listener = Nio2Acceptor.this.getIoServiceEventListener();
            try {
                if (listener != null) {
                    SocketAddress localAddress2 = result2.getLocalAddress();
                    SocketAddress remoteAddress2 = result2.getRemoteAddress();
                    listener.connectionAccepted(Nio2Acceptor.this, localAddress2, remoteAddress2, address);
                }
                IoHandler handler2 = Nio2Acceptor.this.getIoHandler();
                Nio2Acceptor.this.setSocketOptions(result2);
                session2 = Objects.requireNonNull(this.createSession(Nio2Acceptor.this, address, result2, handler2), "No NIO2 session created");
                sessionId = ((Nio2Session)session2).getId();
                handler2.sessionCreated((IoSession)session2);
                Nio2Acceptor.this.sessions.put(sessionId, session2);
                if (((AbstractCloseable)session2).isClosing()) {
                    try {
                        handler2.sessionClosed((IoSession)session2);
                    }
                    finally {
                        Nio2Acceptor.this.unmapSession(sessionId);
                    }
                } else {
                    ((Nio2Session)session2).startReading();
                }
                keepAccepting = true;
            }
            catch (Throwable exc) {
                block20: {
                    if (listener != null) {
                        try {
                            SocketAddress localAddress3 = result2.getLocalAddress();
                            SocketAddress remoteAddress3 = result2.getRemoteAddress();
                            listener.abortAcceptedConnection(Nio2Acceptor.this, localAddress3, remoteAddress3, address, exc);
                        }
                        catch (Exception e2) {
                            if (!Nio2Acceptor.this.log.isDebugEnabled()) break block20;
                            Nio2Acceptor.this.log.debug("onCompleted(" + address + ") listener=" + listener + " ignoring abort event exception", e2);
                        }
                    }
                }
                keepAccepting = this.okToReaccept(exc, address);
                if (session2 != null) {
                    try {
                        session2.close();
                    }
                    catch (Throwable t2) {
                        Nio2Acceptor.this.log.warn("onCompleted(" + address + ") Failed (" + t2.getClass().getSimpleName() + ") to close accepted connection from " + address + ": " + t2.getMessage(), t2);
                    }
                }
                Nio2Acceptor.this.unmapSession(sessionId);
            }
            if (keepAccepting) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                }
            } else {
                Nio2Acceptor.this.log.error("=====> onCompleted({}) no longer accepting incoming connections <====", (Object)address);
            }
        }

        protected Nio2Session createSession(Nio2Acceptor acceptor, SocketAddress address, AsynchronousSocketChannel channel2, IoHandler handler2) throws Throwable {
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("createNio2Session({}) address={}", (Object)acceptor, (Object)address);
            }
            return Nio2Acceptor.this.nio2ServiceFactory.createSession(acceptor, handler2, channel2, address);
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            if (this.okToReaccept(exc, address)) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable t2) {
                    Nio2Acceptor.this.log.error("Failed (" + t2.getClass().getSimpleName() + " to re-accept new connections on " + address + ": " + t2.getMessage(), t2);
                }
            }
        }

        protected boolean okToReaccept(Throwable exc, SocketAddress address) {
            AsynchronousServerSocketChannel channel2 = Nio2Acceptor.this.channels.get(address);
            boolean debugEnabled = Nio2Acceptor.this.log.isDebugEnabled();
            if (channel2 == null) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for untracked channel of {}: {}", exc.getClass().getSimpleName(), address, exc.getMessage());
                }
                return false;
            }
            if (Nio2Acceptor.this.disposing.get()) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for tracked channel of {} while disposing: {}", exc.getClass().getSimpleName(), address, exc.getMessage());
                }
                return false;
            }
            if (!channel2.isOpen()) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Channel is not open ({}), stopping acceptor for {}; msg={}", exc.getClass().getSimpleName(), address, exc.getMessage());
                }
                return false;
            }
            Nio2Acceptor.this.debug("Caught {} while accepting incoming connection from {}: {}", exc.getClass().getSimpleName(), address, exc.getMessage(), exc);
            return true;
        }
    }
}

