/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.io.DefaultIoConnectFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    private final Nio2ServiceFactory nio2ServiceFactory;

    public Nio2Connector(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler handler2, AsynchronousChannelGroup group, ExecutorService resumeTasks) {
        super(propertyResolver, handler2, group, resumeTasks);
        this.nio2ServiceFactory = nio2ServiceFactory;
    }

    @Override
    public IoConnectFuture connect(SocketAddress address, AttributeRepository context, SocketAddress localAddress2) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        AsynchronousSocketChannel channel2 = null;
        AsynchronousSocketChannel socket = null;
        try {
            AsynchronousChannelGroup group = this.getChannelGroup();
            channel2 = this.openAsynchronousSocketChannel(address, group);
            socket = this.setSocketOptions(channel2);
            if (localAddress2 != null) {
                socket.bind(localAddress2);
            }
            Nio2CompletionHandler<Void, Object> completionHandler = ValidateUtils.checkNotNull(this.createConnectionCompletionHandler(future, socket, context, this.propertyResolver, this.getIoHandler()), "No connection completion handler created for %s", (Object)address);
            Future<Void> cf = socket.connect(address);
            Long connectTimeout = CoreModuleProperties.IO_CONNECT_TIMEOUT.get(this.propertyResolver).map(d2 -> {
                long millis;
                if (d2.isZero() || d2.isNegative()) {
                    return null;
                }
                try {
                    millis = d2.toMillis();
                }
                catch (ArithmeticException e2) {
                    millis = Long.MAX_VALUE;
                }
                return millis;
            }).orElse(null);
            Future<?> rf = this.getExecutorService().submit(() -> {
                try {
                    if (connectTimeout != null) {
                        this.log.debug("connect({}): waiting for connection (timeout={}ms)", (Object)address, (Object)connectTimeout);
                        cf.get(connectTimeout, TimeUnit.MILLISECONDS);
                    } else {
                        this.log.debug("connect({}): waiting for connection", (Object)address);
                        cf.get();
                    }
                    completionHandler.onCompleted(null, null);
                }
                catch (CancellationException e2) {
                    CancelFuture cancellation = future.cancel();
                    if (cancellation != null) {
                        cancellation.setCanceled(e2);
                    }
                }
                catch (TimeoutException e3) {
                    cf.cancel(true);
                    ConnectException c2 = new ConnectException("I/O connection time-out of " + connectTimeout + "ms expired");
                    c2.initCause(e3);
                    completionHandler.onFailed(c2, null);
                }
                catch (ExecutionException e4) {
                    completionHandler.onFailed(e4, null);
                }
                catch (InterruptedException e5) {
                    completionHandler.onFailed(e5, null);
                    Thread.currentThread().interrupt();
                }
            });
            future.addListener(f2 -> {
                if (f2.isCanceled()) {
                    rf.cancel(false);
                    cf.cancel(true);
                }
            });
        }
        catch (Throwable exc) {
            Throwable t2;
            block11: {
                block10: {
                    t2 = ExceptionUtils.peelException(exc);
                    this.debug("connect({}) failed ({}) to schedule connection: {}", address, t2.getClass().getSimpleName(), t2.getMessage(), t2);
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException err) {
                        if (!debugEnabled) break block10;
                        this.log.debug("connect({}) - failed ({}) to close socket: {}", address, err.getClass().getSimpleName(), err.getMessage());
                    }
                }
                try {
                    if (channel2 != null) {
                        channel2.close();
                    }
                }
                catch (IOException err) {
                    if (!debugEnabled) break block11;
                    this.log.debug("connect({}) - failed ({}) to close channel: {}", address, err.getClass().getSimpleName(), err.getMessage());
                }
            }
            future.setException(t2);
        }
        return future;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    protected Nio2CompletionHandler<Void, Object> createConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler2) {
        return new ConnectionCompletionHandler(future, socket, context, propertyResolver, handler2);
    }

    protected Nio2Session createSession(PropertyResolver propertyResolver, IoHandler handler2, AsynchronousSocketChannel socket) throws Throwable {
        return this.nio2ServiceFactory.createSession(this, handler2, socket, null);
    }

    protected class ConnectionCompletionHandler
    extends Nio2CompletionHandler<Void, Object> {
        protected final IoConnectFuture future;
        protected final AsynchronousSocketChannel socket;
        protected final AttributeRepository context;
        protected final PropertyResolver propertyResolver;
        protected final IoHandler handler;

        protected ConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler2) {
            this.future = future;
            this.socket = socket;
            this.context = context;
            this.propertyResolver = propertyResolver;
            this.handler = handler2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(Void result2, Object attachment) {
            block19: {
                Long sessionId = null;
                IoServiceEventListener listener = Nio2Connector.this.getIoServiceEventListener();
                try {
                    if (listener != null) {
                        SocketAddress local = this.socket.getLocalAddress();
                        SocketAddress remote = this.socket.getRemoteAddress();
                        listener.connectionEstablished(Nio2Connector.this, local, this.context, remote);
                    }
                    Nio2Session session2 = Nio2Connector.this.createSession(this.propertyResolver, this.handler, this.socket);
                    if (this.context != null) {
                        session2.setAttribute(AttributeRepository.class, this.context);
                    }
                    this.handler.sessionCreated(session2);
                    sessionId = session2.getId();
                    Nio2Connector.this.sessions.put(sessionId, session2);
                    this.future.setSession(session2);
                    if (session2 != this.future.getSession()) {
                        session2.close(true);
                        throw new CancellationException();
                    }
                    if (session2.isClosing()) {
                        try {
                            this.handler.sessionClosed(session2);
                            break block19;
                        }
                        finally {
                            Nio2Connector.this.unmapSession(sessionId);
                        }
                    }
                    session2.startReading();
                }
                catch (CancellationException e2) {
                    throw e2;
                }
                catch (Throwable exc) {
                    Throwable t2;
                    block21: {
                        boolean debugEnabled;
                        block20: {
                            t2 = ExceptionUtils.peelException(exc);
                            debugEnabled = Nio2Connector.this.log.isDebugEnabled();
                            if (listener != null) {
                                try {
                                    SocketAddress localAddress2 = this.socket.getLocalAddress();
                                    SocketAddress remoteAddress2 = this.socket.getRemoteAddress();
                                    listener.abortEstablishedConnection(Nio2Connector.this, localAddress2, this.context, remoteAddress2, t2);
                                }
                                catch (Exception e3) {
                                    if (!debugEnabled) break block20;
                                    Nio2Connector.this.log.debug("onCompleted() listener=" + listener + " ignoring abort event exception", e3);
                                }
                            }
                        }
                        Nio2Connector.this.log.debug("onCompleted - failed to start session: {} {}", t2.getClass().getSimpleName(), t2.getMessage(), t2);
                        IoSession session3 = this.future.getSession();
                        if (session3 != null) {
                            try {
                                session3.close(true);
                            }
                            finally {
                                this.future.setException(t2);
                            }
                        }
                        try {
                            this.socket.close();
                        }
                        catch (IOException err) {
                            if (!debugEnabled) break block21;
                            Nio2Connector.this.log.debug("onCompleted - failed to close socket: {} {}", (Object)err.getClass().getSimpleName(), (Object)err.getMessage());
                        }
                    }
                    this.future.setException(t2);
                    Nio2Connector.this.unmapSession(sessionId);
                }
            }
        }

        @Override
        protected void onFailed(Throwable exc, Object attachment) {
            this.future.setException(exc);
        }
    }
}

