/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.io.WriteAbortedException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Session
extends AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler ioHandler;
    private final AsynchronousSocketChannel socketChannel;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress acceptanceAddress;
    private final PropertyResolver propertyResolver;
    private final Queue<Nio2DefaultIoWriteFuture> writes = new ConcurrentLinkedQueue<Nio2DefaultIoWriteFuture>();
    private final AtomicReference<Nio2DefaultIoWriteFuture> currentWrite = new AtomicReference();
    private final AtomicLong readCyclesCounter = new AtomicLong();
    private final AtomicLong lastReadCycleStart = new AtomicLong();
    private final AtomicLong writeCyclesCounter = new AtomicLong();
    private final AtomicLong lastWriteCycleStart = new AtomicLong();
    private final AtomicBoolean outputShutDown = new AtomicBoolean();
    private final Object suspendLock = new Object();
    private volatile boolean suspend;
    private volatile Runnable readRunnable;
    private Thread readerThread;

    public Nio2Session(Nio2Service service, PropertyResolver propertyResolver, IoHandler handler2, AsynchronousSocketChannel socket, SocketAddress acceptanceAddress) throws IOException {
        this.service = Objects.requireNonNull(service, "No service instance");
        this.propertyResolver = Objects.requireNonNull(propertyResolver, "No property resolver");
        this.ioHandler = Objects.requireNonNull(handler2, "No IoHandler");
        this.socketChannel = Objects.requireNonNull(socket, "No socket channel");
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        this.acceptanceAddress = acceptanceAddress;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating IoSession on {} from {} via {}", this.localAddress, this.remoteAddress, acceptanceAddress);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Object key2) {
        Map<Object, Object> map2 = this.attributes;
        synchronized (map2) {
            return this.attributes.get(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(Object key2, Object value2) {
        Map<Object, Object> map2 = this.attributes;
        synchronized (map2) {
            return this.attributes.put(key2, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttributeIfAbsent(Object key2, Object value2) {
        Map<Object, Object> map2 = this.attributes;
        synchronized (map2) {
            return this.attributes.putIfAbsent(key2, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(Object key2) {
        Map<Object, Object> map2 = this.attributes;
        synchronized (map2) {
            return this.attributes.remove(key2);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public AsynchronousSocketChannel getSocket() {
        return this.socketChannel;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void suspend() {
        block4: {
            AsynchronousSocketChannel socket = this.getSocket();
            try {
                socket.shutdownInput();
            }
            catch (IOException e2) {
                this.debug("suspend({}) failed ({}) to shutdown input: {}", this, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
            try {
                socket.shutdownOutput();
            }
            catch (IOException e3) {
                if (!this.log.isDebugEnabled()) break block4;
                this.debug("suspend({}) failed ({}) to shutdown output: {}", this, e3.getClass().getSimpleName(), e3.getMessage(), e3);
            }
        }
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeBuffer({}) writing {} bytes", (Object)this, (Object)buffer.available());
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture(this.getRemoteAddress(), null, buf);
        if (this.isClosing()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void exceptionCaught(Throwable exc) {
        if (this.closeFuture.isClosed()) {
            return;
        }
        AsynchronousSocketChannel socket = this.getSocket();
        if (this.isOpen() && socket.isOpen()) {
            IoHandler handler2 = this.getIoHandler();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exceptionCaught({}) caught {}[{}] - calling handler", this, exc.getClass().getSimpleName(), exc.getMessage());
                }
                handler2.exceptionCaught(this, exc);
            }
            catch (Throwable e2) {
                Throwable t2 = ExceptionUtils.peelException(e2);
                this.debug("exceptionCaught({}) Exception handler threw {}, closing the session: {}", this, t2.getClass().getSimpleName(), t2.getMessage(), t2);
            }
        }
        this.close(true);
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        String closeId = this.toString();
        return this.builder().when(closeId, this.writes).run(closeId, () -> {
            try {
                AsynchronousSocketChannel socket = this.getSocket();
                if (socket.isOpen()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException e2) {
                this.log.trace("doCloseGracefully({}) {} while shutting down output: {}", this, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
        }).build().close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        Nio2DefaultIoWriteFuture future;
        boolean debugEnabled = this.log.isDebugEnabled();
        while ((future = this.writes.poll()) != null) {
            if (future.isWritten()) {
                if (!debugEnabled) continue;
                this.log.debug("doCloseImmediately({}) skip already written future={}", (Object)this, (Object)future);
                continue;
            }
            Throwable error2 = future.getException();
            if (error2 != null) continue;
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) signal write abort for future={}", (Object)this, (Object)future);
            }
            future.setException(new WriteAbortedException("Write request aborted due to immediate session close", null));
        }
        AsynchronousSocketChannel socket = this.getSocket();
        try {
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) closing socket={}", (Object)this, (Object)socket);
            }
            socket.close();
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) socket={} closed", (Object)this, (Object)socket);
            }
        }
        catch (IOException e2) {
            this.debug("doCloseImmediately({}) {} caught while closing socket={}: {}", this, e2.getClass().getSimpleName(), socket, e2.getMessage(), e2);
        }
        this.service.sessionClosed(this);
        super.doCloseImmediately();
        IoHandler handler2 = this.getIoHandler();
        try {
            handler2.sessionClosed(this);
        }
        catch (Throwable e3) {
            this.debug("doCloseImmediately({}) {} while calling IoHandler#sessionClosed: {}", this, e3.getClass().getSimpleName(), e3.getMessage(), e3);
        }
        Map<Object, Object> map2 = this.attributes;
        synchronized (map2) {
            this.attributes.clear();
        }
    }

    @Override
    public Nio2Service getService() {
        return this.service;
    }

    @Override
    public void shutdownOutputStream() throws IOException {
        if (this.outputShutDown.compareAndSet(false, true)) {
            Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture("shutdown-" + this.getRemoteAddress(), null, null);
            this.writes.add(future);
            this.startWriting();
        }
    }

    protected void doShutdownOutputStream(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket) throws IOException {
        try {
            block6: {
                if (socket.isOpen()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doShutdownOutputStream({})", (Object)this);
                    }
                    try {
                        socket.shutdownOutput();
                    }
                    catch (ClosedChannelException e2) {
                        if (!this.log.isTraceEnabled()) break block6;
                        this.log.trace("doShutdownOutputStream({}): socket is already closed", (Object)this);
                    }
                }
            }
            this.writes.remove(future);
            future.setWritten();
            this.finishWrite(future);
        }
        catch (Exception e3) {
            this.handleWriteCycleFailure(future, socket, null, 0, e3, null);
        }
    }

    public void startReading() {
        this.startReading(CoreModuleProperties.NIO2_READ_BUFFER_SIZE.getRequired(this.propertyResolver));
    }

    public void startReading(int bufSize) {
        this.startReading(new byte[bufSize]);
    }

    public void startReading(byte[] buf) {
        this.startReading(buf, 0, buf.length);
    }

    public void startReading(byte[] buf, int offset, int len2) {
        this.startReading(ByteBuffer.wrap(buf, offset, len2));
    }

    public void startReading(ByteBuffer buffer) {
        this.doReadCycle(buffer, Readable.readable(buffer));
    }

    protected void doReadCycle(ByteBuffer buffer, Readable bufReader) {
        Nio2CompletionHandler<Integer, Object> completion = Objects.requireNonNull(this.createReadCycleCompletionHandler(buffer, bufReader), "No completion handler created");
        this.doReadCycle(buffer, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createReadCycleCompletionHandler(final ByteBuffer buffer, final Readable bufReader) {
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result2, Object attachment) {
                Nio2Session.this.readerThread = Thread.currentThread();
                try {
                    Nio2Session.this.handleReadCycleCompletion(buffer, bufReader, this, result2, attachment);
                }
                finally {
                    Nio2Session.this.readerThread = null;
                }
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.readerThread = null;
                Nio2Session.this.handleReadCycleFailure(buffer, bufReader, exc, attachment);
            }
        };
    }

    protected void handleReadCycleCompletion(ByteBuffer buffer, Readable bufReader, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result2, Object attachment) {
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (result2 >= 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("handleReadCycleCompletion({}) read {} bytes after {} nanos at cycle={}", this, result2, System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter);
                }
                buffer.flip();
                IoHandler handler2 = this.getIoHandler();
                handler2.messageReceived(this, bufReader);
                if (!this.closeFuture.isClosed()) {
                    this.doReadCycle(buffer, completionHandler);
                } else if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) IoSession has been closed, stop reading", (Object)this);
                }
            } else {
                if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) Socket has been disconnected (result={}), closing IoSession now", (Object)this, (Object)result2);
                }
                this.close(true);
            }
        }
        catch (Throwable exc) {
            completionHandler.failed(exc, attachment);
        }
    }

    protected void handleReadCycleFailure(ByteBuffer buffer, Readable bufReader, Throwable exc, Object attachment) {
        this.debug("handleReadCycleFailure({}) {} after {} nanos at read cycle={}: {}", this, exc.getClass().getSimpleName(), System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter, exc.getMessage(), exc);
        this.exceptionCaught(exc);
    }

    @Override
    public void suspendRead() {
        this.log.trace("suspendRead({})", (Object)this);
        boolean prev = this.suspend;
        this.suspend = true;
        if (!prev) {
            this.log.debug("suspendRead({}) requesting read suspension", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeRead() {
        this.log.trace("resumeRead({})", (Object)this);
        if (this.suspend) {
            Runnable runnable2;
            Object object = this.suspendLock;
            synchronized (object) {
                this.suspend = false;
                runnable2 = this.readRunnable;
                this.readRunnable = null;
            }
            if (runnable2 != null && !Thread.currentThread().equals(this.readerThread)) {
                this.log.debug("resumeRead({}) resuming read", (Object)this);
                this.service.getExecutorService().execute(runnable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReadCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        if (this.suspend) {
            this.log.debug("doReadCycle({}) suspending reading", (Object)this);
            Object object = this.suspendLock;
            synchronized (object) {
                if (this.suspend) {
                    this.readRunnable = () -> this.doReadCycle(buffer, completion);
                    return;
                }
            }
        }
        AsynchronousSocketChannel socket = this.getSocket();
        Duration readTimeout = CoreModuleProperties.NIO2_READ_TIMEOUT.getRequired(this.propertyResolver);
        this.readCyclesCounter.incrementAndGet();
        this.lastReadCycleStart.set(System.nanoTime());
        buffer.clear();
        socket.read(buffer, readTimeout.toMillis(), TimeUnit.MILLISECONDS, null, completion);
    }

    protected void startWriting() {
        Nio2DefaultIoWriteFuture future = this.writes.peek();
        if (future == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, future)) {
            return;
        }
        try {
            AsynchronousSocketChannel socket = this.getSocket();
            ByteBuffer buffer = future.getBuffer();
            if (buffer == null) {
                this.doShutdownOutputStream(future, socket);
            } else {
                Nio2CompletionHandler<Integer, Object> handler2 = Objects.requireNonNull(this.createWriteCycleCompletionHandler(future, socket, buffer), "No write cycle completion handler created");
                this.doWriteCycle(buffer, handler2);
            }
        }
        catch (Throwable e2) {
            future.setException(e2);
            this.finishWrite(future);
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeSshException(e2);
        }
    }

    protected void doWriteCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        Duration writeTimeout = CoreModuleProperties.NIO2_MIN_WRITE_TIMEOUT.getRequired(this.propertyResolver);
        this.writeCyclesCounter.incrementAndGet();
        this.lastWriteCycleStart.set(System.nanoTime());
        socket.write(buffer, writeTimeout.toMillis(), TimeUnit.MILLISECONDS, null, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createWriteCycleCompletionHandler(final Nio2DefaultIoWriteFuture future, final AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        final int writeLen = buffer.remaining();
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result2, Object attachment) {
                Nio2Session.this.handleCompletedWriteCycle(future, socket, buffer, writeLen, this, result2, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleWriteCycleFailure(future, socket, buffer, writeLen, exc, attachment);
            }
        };
    }

    protected void handleCompletedWriteCycle(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result2, Object attachment) {
        if (buffer.hasRemaining()) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleCompletedWriteCycle({}) incomplete write of writeLen={}. Written result={}, resume writing buffer.remaining()={} at cycle={} after {} nanos", this, writeLen, result2, buffer.remaining(), this.writeCyclesCounter.get(), System.nanoTime() - this.lastWriteCycleStart.get());
                }
                this.doWriteCycle(buffer, completionHandler);
            }
            catch (Throwable t2) {
                this.warn("handleCompletedWriteCycle({}) {} while writing to socket len={}, result={}: {}", this, t2.getClass().getSimpleName(), writeLen, result2, t2.getMessage(), t2);
                future.setException(t2);
                this.finishWrite(future);
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleCompletedWriteCycle({}) finished writing len={} at cycle={} after {} nanos", this, writeLen, this.writeCyclesCounter.get(), System.nanoTime() - this.lastWriteCycleStart.get());
            }
            this.writes.remove(future);
            future.setWritten();
            this.finishWrite(future);
        }
    }

    protected void handleWriteCycleFailure(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Throwable exc, Object attachment) {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.debug("handleWriteCycleFailure({}) failed ({}) to write {} bytes at write cycle={} after {} nanos: {}", this, exc.getClass().getSimpleName(), writeLen, this.writeCyclesCounter, System.nanoTime() - this.lastWriteCycleStart.get(), exc.getMessage(), exc);
            }
            future.setException(exc);
            this.exceptionCaught(exc);
            try {
                this.finishWrite(future);
            }
            catch (RuntimeException e2) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace("handleWriteCycleFailure({}) failed ({}) to finish writing: {}", this, e2.getClass().getSimpleName(), e2.getMessage());
            }
        }
    }

    protected void finishWrite(Nio2DefaultIoWriteFuture future) {
        this.writes.remove(future);
        this.currentWrite.compareAndSet(future, null);
        this.startWriting();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

