/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.kex.KeyEncapsulationMethod;
import org.apache.sshd.common.random.JceRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;

final class MLKEM {
    private MLKEM() {
    }

    static KeyEncapsulationMethod.Client getClient(Parameters parameters2) {
        return new Client(parameters2);
    }

    static KeyEncapsulationMethod.Server getServer(Parameters parameters2) {
        return new Server(parameters2);
    }

    private static class Client
    implements KeyEncapsulationMethod.Client {
        private final Parameters parameters;
        private MLKEMExtractor extractor;
        private MLKEMPublicKeyParameters publicKey;

        Client(Parameters parameters2) {
            this.parameters = Objects.requireNonNull(parameters2, "No MLKEM.Parameters given");
        }

        @Override
        public void init() {
            MLKEMKeyPairGenerator gen = new MLKEMKeyPairGenerator();
            gen.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(JceRandom.getGlobalInstance(), (MLKEMParameters)this.parameters.getMLKEMParameters()));
            AsymmetricCipherKeyPair pair = gen.generateKeyPair();
            this.extractor = new MLKEMExtractor((MLKEMPrivateKeyParameters)pair.getPrivate());
            this.publicKey = (MLKEMPublicKeyParameters)pair.getPublic();
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey.getEncoded();
        }

        @Override
        public byte[] extractSecret(byte[] encapsulated) {
            if (encapsulated.length != this.getEncapsulationLength()) {
                throw new IllegalArgumentException("KEM encpsulation has wrong length: " + encapsulated.length);
            }
            return this.extractor.extractSecret(encapsulated);
        }

        @Override
        public int getEncapsulationLength() {
            return this.extractor.getEncapsulationLength();
        }
    }

    static enum Parameters implements OptionalFeature
    {
        mlkem768(1184){

            @Override
            Object getMLKEMParameters() {
                return MLKEMParameters.ml_kem_768;
            }
        }
        ,
        mlkem1024(1568){

            @Override
            Object getMLKEMParameters() {
                return MLKEMParameters.ml_kem_1024;
            }
        };

        private final int publicKeySize;

        private Parameters(int publicKeySize) {
            this.publicKeySize = publicKeySize;
        }

        abstract Object getMLKEMParameters();

        int getPublicKeySize() {
            return this.publicKeySize;
        }

        @Override
        public boolean isSupported() {
            try {
                return this.getMLKEMParameters() != null;
            }
            catch (Throwable e2) {
                return false;
            }
        }
    }

    private static class Server
    implements KeyEncapsulationMethod.Server {
        private final Parameters parameters;
        private SecretWithEncapsulation value;

        Server(Parameters parameters2) {
            this.parameters = Objects.requireNonNull(parameters2, "No MLKEM.Parameters given");
        }

        @Override
        public int getPublicKeyLength() {
            return this.parameters.getPublicKeySize();
        }

        @Override
        public byte[] init(byte[] publicKey) {
            int pkBytes = this.getPublicKeyLength();
            if (publicKey.length < pkBytes) {
                throw new IllegalArgumentException("KEM public key too short: " + publicKey.length);
            }
            byte[] pk = Arrays.copyOf(publicKey, pkBytes);
            MLKEMGenerator kemGenerator = new MLKEMGenerator(JceRandom.getGlobalInstance());
            MLKEMPublicKeyParameters params = new MLKEMPublicKeyParameters((MLKEMParameters)this.parameters.getMLKEMParameters(), pk);
            this.value = kemGenerator.generateEncapsulated((AsymmetricKeyParameter)params);
            return Arrays.copyOfRange(publicKey, pkBytes, publicKey.length);
        }

        @Override
        public byte[] getSecret() {
            return this.value.getSecret();
        }

        @Override
        public byte[] getEncapsulation() {
            return this.value.getEncapsulation();
        }
    }
}

