/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.kex.CurveSizeIndicator;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum MontgomeryCurve implements KeySizeIndicator,
CurveSizeIndicator,
OptionalFeature
{
    x25519("X25519", 32, new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0}),
    x448("X448", 56, new byte[]{48, 66, 48, 5, 6, 3, 43, 101, 111, 3, 57, 0});

    private final String algorithm;
    private final int keySize;
    private final boolean supported;
    private final KeyPairGenerator keyPairGenerator;
    private final KeyFactory keyFactory;
    private final byte[] encodedPublicKeyPrefix;

    private MontgomeryCurve(String algorithm, int keySize, byte[] encodedPublicKeyPrefix) {
        boolean isSupported;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.encodedPublicKeyPrefix = encodedPublicKeyPrefix;
        KeyPairGenerator generator = null;
        KeyFactory factory2 = null;
        try {
            SecurityUtils.getKeyAgreement(algorithm);
            generator = SecurityUtils.getKeyPairGenerator(algorithm);
            factory2 = SecurityUtils.getKeyFactory(algorithm);
            isSupported = true;
        }
        catch (GeneralSecurityException ignored) {
            isSupported = false;
        }
        this.supported = isSupported;
        this.keyPairGenerator = generator;
        this.keyFactory = factory2;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getByteLength() {
        return this.keySize;
    }

    @Override
    public int getKeySize() {
        return this.getByteLength() * 8;
    }

    @Override
    public boolean isSupported() {
        return this.supported && !SecurityUtils.isFipsMode();
    }

    public KeyAgreement createKeyAgreement() throws GeneralSecurityException {
        return SecurityUtils.getKeyAgreement(this.algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair() {
        MontgomeryCurve montgomeryCurve = this;
        synchronized (montgomeryCurve) {
            return this.keyPairGenerator.generateKeyPair();
        }
    }

    public byte[] encode(PublicKey key2) throws InvalidKeyException {
        byte[] subjectPublicKeyInfo = key2.getEncoded();
        byte[] result2 = Arrays.copyOfRange(subjectPublicKeyInfo, subjectPublicKeyInfo.length - this.getByteLength(), subjectPublicKeyInfo.length);
        return result2;
    }

    public PublicKey decode(byte[] key2) throws InvalidKeySpecException {
        int size2 = this.getByteLength();
        int offset = key2.length - size2;
        if (offset < 0 || offset > 1) {
            throw new InvalidKeySpecException("Provided key has wrong length (" + key2.length + " bytes) for " + this.getAlgorithm());
        }
        if (offset == 1 && key2[0] != 0) {
            throw new InvalidKeySpecException("Provided key for " + this.getAlgorithm() + " has extra byte, but it's non-zero: 0x" + Integer.toHexString(key2[0] & 0xFF));
        }
        byte[] encoded = Arrays.copyOf(this.encodedPublicKeyPrefix, this.encodedPublicKeyPrefix.length + size2);
        System.arraycopy(key2, offset, encoded, this.encodedPublicKeyPrefix.length, size2);
        return this.keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
    }
}

