/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.CurveSizeIndicator;
import org.apache.sshd.common.kex.MontgomeryCurve;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class XDH
extends AbstractDH
implements CurveSizeIndicator {
    protected final MontgomeryCurve curve;
    protected final boolean raw;
    protected byte[] f;

    public XDH(MontgomeryCurve curve, boolean raw) throws Exception {
        this.curve = Objects.requireNonNull(curve, "No MontgomeryCurve provided");
        this.raw = raw;
        this.myKeyAgree = curve.createKeyAgreement();
    }

    @Override
    public int getByteLength() {
        return this.curve.getByteLength();
    }

    @Override
    protected byte[] calculateE() throws Exception {
        KeyPair keyPair = this.curve.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        return this.curve.encode(keyPair.getPublic());
    }

    @Override
    public void setF(byte[] f2) {
        this.f = Objects.requireNonNull(f2, "No 'f' value provided");
    }

    @Override
    public void putE(Buffer buffer, byte[] e2) {
        buffer.putBytes(e2);
    }

    @Override
    public void putF(Buffer buffer, byte[] f2) {
        buffer.putBytes(f2);
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        this.myKeyAgree.doPhase(this.curve.decode(this.f), true);
        byte[] secret = this.myKeyAgree.generateSecret();
        return this.raw ? secret : XDH.stripLeadingZeroes(secret);
    }
}

