/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.dh;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractDHKeyExchange
extends AbstractLoggingBean
implements KeyExchange {
    protected byte[] v_s;
    protected byte[] v_c;
    protected byte[] i_s;
    protected byte[] i_c;
    protected Digest hash;
    protected byte[] k;
    protected byte[] h;
    private byte[] e;
    private BigInteger eValue;
    private byte[] f;
    private BigInteger fValue;
    private final Session session;

    protected AbstractDHKeyExchange(Session session2) {
        this.session = Objects.requireNonNull(session2, "No session provided");
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        this.v_s = ValidateUtils.checkNotNullAndNotEmpty(v_s, "No v_s value");
        this.v_c = ValidateUtils.checkNotNullAndNotEmpty(v_c, "No v_c value");
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(i_s, "No i_s value");
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(i_c, "No i_c value");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.h;
    }

    @Override
    public byte[] getK() {
        return this.k;
    }

    protected byte[] getE() {
        return this.e;
    }

    protected BigInteger getEValue() {
        if (this.eValue == null) {
            this.eValue = BufferUtils.fromMPIntBytes(this.getE());
        }
        return this.eValue;
    }

    protected byte[] updateE(Buffer buffer) {
        return this.updateE(buffer.getMPIntAsBytes());
    }

    protected byte[] updateE(byte[] mpInt) {
        this.setE(mpInt);
        return mpInt;
    }

    protected void setE(byte[] e2) {
        this.e = e2;
        if (this.eValue != null) {
            this.eValue = null;
        }
    }

    protected void validateEValue(BigInteger pValue) throws SshException {
        BigInteger value2 = Objects.requireNonNull(this.getEValue(), "No DH 'e' value set");
        if (!KeyExchange.isValidDHValue(value2, pValue)) {
            throw new SshException(3, "Protocol error: invalid DH 'e' value");
        }
    }

    protected byte[] getF() {
        return this.f;
    }

    protected BigInteger getFValue() {
        if (this.fValue == null) {
            this.fValue = BufferUtils.fromMPIntBytes(this.getF());
        }
        return this.fValue;
    }

    protected byte[] updateF(Buffer buffer) {
        return this.updateF(buffer.getMPIntAsBytes());
    }

    protected byte[] updateF(byte[] mpInt) {
        this.setF(mpInt);
        return mpInt;
    }

    protected void setF(byte[] f2) {
        this.f = f2;
        if (this.fValue != null) {
            this.fValue = null;
        }
    }

    protected void validateFValue(BigInteger pValue) throws SshException {
        BigInteger value2 = Objects.requireNonNull(this.getFValue(), "No DH 'f' value set");
        if (!KeyExchange.isValidDHValue(value2, pValue)) {
            throw new SshException(3, "Protocol error: invalid DH 'f' value");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    protected byte[] normalize(byte[] mpInt) {
        if (!NumberUtils.isEmpty(mpInt) && (mpInt[0] & 0x80) != 0) {
            byte[] result2 = new byte[mpInt.length + 1];
            result2[0] = 0;
            System.arraycopy(mpInt, 0, result2, 1, mpInt.length);
            return result2;
        }
        return mpInt;
    }
}

