/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.parser.HostBoundPubkeyAuthentication;
import org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultClientKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final DefaultClientKexExtensionHandler INSTANCE = new DefaultClientKexExtensionHandler();
    public static final AttributeRepository.AttributeKey<Set<String>> SERVER_ALGORITHMS = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<Integer> HOSTBOUND_AUTHENTICATION = new AttributeRepository.AttributeKey();

    @Override
    public boolean isKexExtensionsAvailable(Session session2, KexExtensionHandler.AvailabilityPhase phase) throws IOException {
        return !KexExtensionHandler.AvailabilityPhase.PREKEX.equals((Object)phase);
    }

    @Override
    public boolean handleKexExtensionRequest(Session session2, int index, int count2, String name, byte[] data2) throws IOException {
        if ("server-sig-algs".equals(name)) {
            this.handleServerSignatureAlgorithms(session2, (Collection)ServerSignatureAlgorithms.INSTANCE.parseExtension(data2));
        } else if ("publickey-hostbound@openssh.com".equals(name)) {
            Integer version2 = (Integer)HostBoundPubkeyAuthentication.INSTANCE.parseExtension(data2);
            if (version2 == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleKexExtensionRequest({}) : ignoring unknown {} extension", (Object)session2, (Object)"publickey-hostbound@openssh.com");
                }
            } else if (version2 != 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleKexExtensionRequest({}) : ignoring unknown {} version {}", session2, "publickey-hostbound@openssh.com", version2);
                }
            } else {
                session2.setAttribute(HOSTBOUND_AUTHENTICATION, version2);
            }
        }
        return true;
    }

    protected void handleServerSignatureAlgorithms(Session session2, Collection<String> serverAlgorithms) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServerSignatureAlgorithms({}): {}", (Object)session2, (Object)serverAlgorithms);
        }
        if (serverAlgorithms != null && !serverAlgorithms.isEmpty()) {
            ArrayList<NamedFactory<Signature>> clientAlgorithms = new ArrayList<NamedFactory<Signature>>(session2.getSignatureFactories());
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms before: {}", (Object)session2, (Object)clientAlgorithms);
            }
            ArrayList<NamedFactory> unknown = new ArrayList<NamedFactory>();
            TreeSet<String> known2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            known2.addAll(serverAlgorithms);
            Iterator i2 = clientAlgorithms.iterator();
            while (i2.hasNext()) {
                NamedFactory algo = (NamedFactory)i2.next();
                if (known2.contains(algo.getName())) continue;
                unknown.add(algo);
                i2.remove();
            }
            clientAlgorithms.addAll(unknown);
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms after: {}", (Object)session2, (Object)clientAlgorithms);
            }
            session2.setAttribute(SERVER_ALGORITHMS, known2);
            session2.setSignatureFactories(clientAlgorithms);
        }
    }
}

