/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultServerKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final DefaultServerKexExtensionHandler INSTANCE = new DefaultServerKexExtensionHandler();
    public static final AttributeRepository.AttributeKey<Boolean> CLIENT_REQUESTED_EXT_INFO = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<Boolean> EXT_INFO_SENT_AT_NEWKEYS = new AttributeRepository.AttributeKey();

    @Override
    public void handleKexInitProposal(Session session2, boolean initiator, Map<KexProposalOption, String> proposal) throws Exception {
        if (!initiator && session2.getAttribute(CLIENT_REQUESTED_EXT_INFO) == null) {
            String algorithms = proposal.get((Object)KexProposalOption.ALGORITHMS);
            boolean clientWantsExtInfo = Arrays.asList(GenericUtils.split(algorithms, ',')).contains("ext-info-c");
            session2.setAttribute(CLIENT_REQUESTED_EXT_INFO, clientWantsExtInfo);
            if (clientWantsExtInfo && this.log.isTraceEnabled()) {
                this.log.trace("handleKexInitProposal({}): got ext-info-c from client", (Object)session2);
            }
        }
    }

    @Override
    public void sendKexExtensions(Session session2, KexExtensionHandler.KexPhase phase) throws Exception {
        Boolean doExtInfo;
        if (phase == KexExtensionHandler.KexPhase.NEWKEYS) {
            Boolean alreadySent = session2.getAttribute(EXT_INFO_SENT_AT_NEWKEYS);
            if (alreadySent != null && alreadySent.booleanValue()) {
                return;
            }
            session2.setAttribute(EXT_INFO_SENT_AT_NEWKEYS, Boolean.TRUE);
        }
        if ((doExtInfo = session2.getAttribute(CLIENT_REQUESTED_EXT_INFO)) == null || !doExtInfo.booleanValue()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendKexExtensions({})[{}]: client did not send ext-info-c; skipping sending SSH_MSG_EXT_INFO", (Object)session2, (Object)phase);
            }
            return;
        }
        LinkedHashMap extensions = new LinkedHashMap();
        this.collectExtensions(session2, phase, extensions::put);
        if (!extensions.isEmpty()) {
            Buffer buffer = session2.createBuffer((byte)7);
            KexExtensions.putExtensions(extensions.entrySet(), buffer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendKexExtensions({})[{}]: sending SSH_MSG_EXT_INFO with {} info records", new Object[]{session2, phase, extensions.size()});
            }
            session2.writePacket(buffer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("sendKexExtensions({})[{}]: no extension info; skipping sending SSH_MSG_EXT_INFO", (Object)session2, (Object)phase);
        }
    }

    public void collectExtensions(Session session2, KexExtensionHandler.KexPhase phase, BiConsumer<String, Object> marshaller) {
        if (phase == KexExtensionHandler.KexPhase.NEWKEYS) {
            List<String> algorithms = session2.getSignatureFactoriesNames();
            if (!GenericUtils.isEmpty(algorithms)) {
                marshaller.accept("server-sig-algs", algorithms);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("collectExtensions({})[{}]: extension info {}: {}", new Object[]{session2, phase, "server-sig-algs", String.join((CharSequence)",", algorithms)});
                }
            } else if (this.log.isWarnEnabled()) {
                this.log.warn("collectExtensions({})[{}]: extension info {} has no algorithms; skipping", new Object[]{session2, phase, "server-sig-algs"});
            }
        }
    }
}

