/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;

public interface KexExtensionHandler {
    default public boolean isKexExtensionsAvailable(Session session2, AvailabilityPhase phase) throws IOException {
        return true;
    }

    default public void handleKexInitProposal(Session session2, boolean initiator, Map<KexProposalOption, String> proposal) throws Exception {
    }

    default public void handleKexExtensionNegotiation(Session session2, KexProposalOption option, String nValue, Map<KexProposalOption, String> c2sOptions, String cValue, Map<KexProposalOption, String> s2cOptions, String sValue) throws Exception {
    }

    default public void sendKexExtensions(Session session2, KexPhase phase) throws Exception {
    }

    default public boolean handleKexExtensionsMessage(Session session2, Buffer buffer) throws Exception {
        byte[] data2;
        String name;
        int count2 = buffer.getInt();
        for (int index = 0; index < count2 && this.handleKexExtensionRequest(session2, index, count2, name = buffer.getString(), data2 = buffer.getBytes()); ++index) {
        }
        return true;
    }

    default public boolean handleKexCompressionMessage(Session session2, Buffer buffer) throws Exception {
        return true;
    }

    default public boolean handleKexExtensionRequest(Session session2, int index, int count2, String name, byte[] data2) throws Exception {
        return true;
    }

    public static enum KexPhase {
        NEWKEYS,
        AUTHOK;

        public static final Set<KexPhase> VALUES;

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(KexPhase.class));
        }
    }

    public static enum AvailabilityPhase {
        PREKEX,
        PROPOSAL,
        NEWKEYS,
        AUTHOK;

    }
}

