/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.apache.sshd.common.util.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostBoundPubkeyAuthentication
extends AbstractKexExtensionParser<Integer> {
    public static final String NAME = "publickey-hostbound@openssh.com";
    public static final String AUTH_NAME = "publickey-hostbound-v00@openssh.com";
    public static final HostBoundPubkeyAuthentication INSTANCE = new HostBoundPubkeyAuthentication();
    private static final Logger LOG = LoggerFactory.getLogger(HostBoundPubkeyAuthentication.class);

    public HostBoundPubkeyAuthentication() {
        super(NAME);
    }

    @Override
    public Integer parseExtension(Buffer buffer) throws IOException {
        return this.parseExtension(buffer.array(), buffer.rpos(), buffer.available());
    }

    @Override
    public Integer parseExtension(byte[] data2, int off, int len2) throws IOException {
        if (len2 <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Inconsistent KEX extension {} received; no data (len={})", (Object)NAME, (Object)len2);
            }
            return null;
        }
        String value2 = new String(data2, off, len2, StandardCharsets.UTF_8);
        try {
            Integer result2 = Integer.parseUnsignedInt(value2);
            LOG.info("Server announced support for {} version {}", (Object)NAME, (Object)result2);
            return result2;
        }
        catch (NumberFormatException e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot parse KEX extension {} version {}", (Object)NAME, (Object)value2);
            }
            return null;
        }
    }

    @Override
    protected void encode(Integer version2, Buffer buffer) throws IOException {
        buffer.putString(version2.toString());
    }
}

