/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ServerSignatureAlgorithms
extends AbstractKexExtensionParser<List<String>> {
    public static final String NAME = "server-sig-algs";
    public static final ServerSignatureAlgorithms INSTANCE = new ServerSignatureAlgorithms();

    public ServerSignatureAlgorithms() {
        super(NAME);
    }

    @Override
    public List<String> parseExtension(byte[] data2, int off, int len2) throws IOException {
        String s2 = len2 <= 0 ? "" : new String(data2, off, len2, StandardCharsets.UTF_8);
        String[] vals = GenericUtils.isEmpty(s2) ? GenericUtils.EMPTY_STRING_ARRAY : GenericUtils.split(s2, ',');
        return GenericUtils.isEmpty(vals) ? Collections.emptyList() : Arrays.asList(vals);
    }

    @Override
    public List<String> parseExtension(Buffer buffer) throws IOException {
        return this.parseExtension(buffer.array(), buffer.rpos(), buffer.available());
    }

    @Override
    protected void encode(List<String> names2, Buffer buffer) throws IOException {
        buffer.putNameList(names2);
    }
}

