/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class FileHostKeyCertificateProvider
extends AbstractLoggingBean
implements HostKeyCertificateProvider {
    private final Collection<? extends Path> files;

    public FileHostKeyCertificateProvider(Path path2) {
        this(path2 == null ? Collections.emptyList() : Collections.singletonList(path2));
    }

    public FileHostKeyCertificateProvider(Path ... files2) {
        this(GenericUtils.isEmpty(files2) ? Collections.emptyList() : Arrays.asList(files2));
    }

    public FileHostKeyCertificateProvider(Collection<? extends Path> files2) {
        this.files = ValidateUtils.checkNotNullAndNotEmpty(files2, "No paths provided", new Object[0]);
    }

    public Collection<? extends Path> getPaths() {
        return this.files;
    }

    @Override
    public Iterable<OpenSshCertificate> loadCertificates(SessionContext session2) throws IOException, GeneralSecurityException {
        Collection<? extends Path> keyPaths = this.getPaths();
        ArrayList<OpenSshCertificate> certificates = new ArrayList<OpenSshCertificate>();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (Path path2 : keyPaths) {
            if (debugEnabled) {
                this.log.debug("loadCertificates({}) loading file {}", (Object)session2, (Object)path2);
            }
            List<String> lines = Files.readAllLines(path2, StandardCharsets.UTF_8);
            int lineNumber = 0;
            for (String line : lines) {
                PublicKey publicKey;
                PublicKeyEntry publicKeyEntry;
                ++lineNumber;
                if (GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) || line.charAt(0) == '#' || (publicKeyEntry = PublicKeyEntry.parsePublicKeyEntry(line)) == null || (publicKey = publicKeyEntry.resolvePublicKey(session2, null, null)) == null) continue;
                if (!(publicKey instanceof OpenSshCertificate)) {
                    throw new InvalidKeyException("Got unexpected key type in " + path2 + "; line " + lineNumber + ". Expected OpenSSHCertificate.");
                }
                if (!OpenSshCertificate.Type.HOST.equals((Object)((OpenSshCertificate)publicKey).getType())) {
                    throw new InvalidKeyException("OpenSSHCertificate in " + path2 + ", line " + lineNumber + ", is not a host certificate.");
                }
                certificates.add((OpenSshCertificate)publicKey);
            }
        }
        return certificates;
    }
}

