/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.session.SessionContext;

@FunctionalInterface
public interface HostKeyCertificateProvider {
    public Iterable<OpenSshCertificate> loadCertificates(SessionContext var1) throws IOException, GeneralSecurityException;

    default public OpenSshCertificate loadCertificate(SessionContext session2, String keyType) throws IOException, GeneralSecurityException {
        Iterable<OpenSshCertificate> certificates = this.loadCertificates(session2);
        return StreamSupport.stream(certificates.spliterator(), false).filter(pubKey -> Objects.equals(pubKey.getKeyType(), keyType)).findFirst().orElse(null);
    }
}

