/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairProvider
extends KeyIdentityProvider {
    public static final String SSH_RSA = "ssh-rsa";
    public static final String SSH_DSS = "ssh-dss";
    public static final String SSH_ED25519 = "ssh-ed25519";
    public static final String ECDSA_SHA2_NISTP256 = ECCurves.nistp256.getKeyType();
    public static final String ECDSA_SHA2_NISTP384 = ECCurves.nistp384.getKeyType();
    public static final String ECDSA_SHA2_NISTP521 = ECCurves.nistp521.getKeyType();
    public static final String SSH_RSA_CERT = "ssh-rsa-cert-v01@openssh.com";
    public static final String SSH_DSS_CERT = "ssh-dss-cert-v01@openssh.com";
    public static final String SSH_ED25519_CERT = "ssh-ed25519-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP256_CERT = "ecdsa-sha2-nistp256-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP384_CERT = "ecdsa-sha2-nistp384-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP521_CERT = "ecdsa-sha2-nistp521-cert-v01@openssh.com";
    public static final KeyPairProvider EMPTY_KEYPAIR_PROVIDER = new KeyPairProvider(){

        @Override
        public KeyPair loadKey(SessionContext session2, String type2) {
            return null;
        }

        @Override
        public Iterable<String> getKeyTypes(SessionContext session2) {
            return Collections.emptySet();
        }

        @Override
        public Iterable<KeyPair> loadKeys(SessionContext session2) {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY_KEYPAIR_PROVIDER";
        }
    };

    default public KeyPair loadKey(SessionContext session2, String type2) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(type2, "No key type to load");
        return GenericUtils.stream(this.loadKeys(session2)).filter(key2 -> type2.equals(KeyUtils.getKeyType(key2))).findFirst().orElse(null);
    }

    default public Iterable<String> getKeyTypes(SessionContext session2) throws IOException, GeneralSecurityException {
        return GenericUtils.stream(this.loadKeys(session2)).map(KeyUtils::getKeyType).filter(GenericUtils::isNotEmpty).collect(Collectors.toSet());
    }

    public static KeyPairProvider wrap(KeyPair ... pairs2) {
        return GenericUtils.isEmpty(pairs2) ? EMPTY_KEYPAIR_PROVIDER : KeyPairProvider.wrap(Arrays.asList(pairs2));
    }

    public static KeyPairProvider wrap(final Iterable<KeyPair> pairs2) {
        return pairs2 == null ? EMPTY_KEYPAIR_PROVIDER : new KeyPairProvider(){

            @Override
            public Iterable<KeyPair> loadKeys(SessionContext session2) {
                return pairs2;
            }

            @Override
            public KeyPair loadKey(SessionContext session2, String type2) {
                for (KeyPair kp : pairs2) {
                    String t2 = KeyUtils.getKeyType(kp);
                    if (!Objects.equals(type2, t2)) continue;
                    return kp;
                }
                return null;
            }

            @Override
            public Iterable<String> getKeyTypes(SessionContext session2) {
                LinkedHashSet<String> types = new LinkedHashSet<String>();
                for (KeyPair kp : pairs2) {
                    String t2 = KeyUtils.getKeyType(kp);
                    if (!GenericUtils.isEmpty(t2) && types.add(t2)) continue;
                }
                return types;
            }
        };
    }
}

