/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class MappedKeyPairProvider
implements KeyPairProvider {
    public static final Function<Map<String, KeyPair>, KeyPairProvider> MAP_TO_KEY_PAIR_PROVIDER = MappedKeyPairProvider::new;
    private final Map<String, KeyPair> pairsMap;

    public MappedKeyPairProvider(KeyPair ... pairs2) {
        this(GenericUtils.isEmpty(pairs2) ? Collections.emptyList() : Arrays.asList(pairs2));
    }

    public MappedKeyPairProvider(Collection<KeyPair> pairs2) {
        this(MappedKeyPairProvider.mapUniquePairs(pairs2));
    }

    public MappedKeyPairProvider(Map<String, KeyPair> pairsMap) {
        this.pairsMap = ValidateUtils.checkNotNullAndNotEmpty(pairsMap, "No pairs map provided", new Object[0]);
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session2) {
        return this.pairsMap.values();
    }

    @Override
    public KeyPair loadKey(SessionContext session2, String type2) {
        return this.pairsMap.get(type2);
    }

    @Override
    public Iterable<String> getKeyTypes(SessionContext session2) {
        return this.pairsMap.keySet();
    }

    public String toString() {
        return String.valueOf(this.pairsMap.keySet());
    }

    public static Map<String, KeyPair> mapUniquePairs(Collection<KeyPair> pairs2) {
        if (GenericUtils.isEmpty(pairs2)) {
            return Collections.emptyMap();
        }
        TreeMap<String, KeyPair> pairsMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (KeyPair kp : pairs2) {
            String keyType = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(kp), "Cannot determine key type");
            KeyPair prev = pairsMap.put(keyType, kp);
            ValidateUtils.checkTrue(prev == null, "Multiple keys of type=%s", (Object)keyType);
        }
        return pairsMap;
    }
}

