/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseMac
implements Mac {
    private final String algorithm;
    private final int defbsize;
    private final int bsize;
    private final byte[] tmp;
    private final boolean etmMode;
    private javax.crypto.Mac mac;
    private String s;

    public BaseMac(String algorithm, int bsize, int defbsize, boolean etmMode) {
        this.algorithm = algorithm;
        this.bsize = bsize;
        this.defbsize = defbsize;
        this.tmp = new byte[defbsize];
        this.etmMode = etmMode;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public int getDefaultBlockSize() {
        return this.defbsize;
    }

    @Override
    public boolean isEncryptThenMac() {
        return this.etmMode;
    }

    @Override
    public void init(byte[] key2) throws Exception {
        if (key2.length > this.defbsize) {
            byte[] tmp = new byte[this.defbsize];
            System.arraycopy(key2, 0, tmp, 0, this.defbsize);
            key2 = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key2, this.algorithm);
        this.mac = SecurityUtils.getMac(this.algorithm);
        this.mac.init(skey);
    }

    @Override
    public void updateUInt(long i2) {
        this.tmp[0] = (byte)(i2 >>> 24);
        this.tmp[1] = (byte)(i2 >>> 16);
        this.tmp[2] = (byte)(i2 >>> 8);
        this.tmp[3] = (byte)i2;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] buf, int offset, int len2) {
        this.mac.update(buf, offset, len2);
    }

    @Override
    public void doFinal(byte[] buf, int offset) throws Exception {
        int defaultSize;
        int blockSize = this.getBlockSize();
        if (blockSize != (defaultSize = this.getDefaultBlockSize())) {
            this.mac.doFinal(this.tmp, 0);
            System.arraycopy(this.tmp, 0, buf, offset, blockSize);
        } else {
            this.mac.doFinal(buf, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseMac baseMac = this;
        synchronized (baseMac) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "] -  block=" + this.getBlockSize() + "/" + this.getDefaultBlockSize() + " bytes, encrypt-then-mac=" + this.isEncryptThenMac();
            }
        }
        return this.s;
    }
}

