/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;

public interface SessionHeartbeatController
extends PropertyResolver {
    default public HeartbeatType getSessionHeartbeatType() {
        return CommonModuleProperties.SESSION_HEARTBEAT_TYPE.getRequired(this);
    }

    default public Duration getSessionHeartbeatInterval() {
        return CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.getRequired(this);
    }

    default public void disableSessionHeartbeat() {
        this.setSessionHeartbeat(HeartbeatType.NONE, Duration.ZERO);
    }

    default public void setSessionHeartbeat(HeartbeatType type2, TimeUnit unit, long count2) {
        Objects.requireNonNull(unit, "No heartbeat time unit provided");
        this.setSessionHeartbeat(type2, Duration.ofMillis(TimeUnit.MILLISECONDS.convert(count2, unit)));
    }

    default public void setSessionHeartbeat(HeartbeatType type2, Duration interval) {
        Objects.requireNonNull(type2, "No heartbeat type specified");
        Objects.requireNonNull(interval, "No heartbeat time interval provided");
        CommonModuleProperties.SESSION_HEARTBEAT_TYPE.set(this, type2);
        CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.set(this, interval);
    }

    public static enum HeartbeatType {
        NONE,
        IGNORE,
        RESERVED;

        public static final Set<HeartbeatType> VALUES;

        public static HeartbeatType fromName(String name) {
            return GenericUtils.isEmpty(name) ? null : (HeartbeatType)VALUES.stream().filter(v -> name.equalsIgnoreCase(v.name())).findAny().orElse(null);
        }

        static {
            VALUES = EnumSet.allOf(HeartbeatType.class);
        }
    }
}

