/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.List;
import java.util.Map;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.SshdEventListener;

public interface SessionListener
extends SshdEventListener {
    default public void sessionEstablished(Session session2) {
    }

    default public void sessionCreated(Session session2) {
    }

    default public void sessionPeerIdentificationSend(Session session2, String version2, List<String> extraLines) {
    }

    default public void sessionPeerIdentificationLine(Session session2, String line, List<String> extraLines) {
    }

    default public void sessionPeerIdentificationReceived(Session session2, String version2, List<String> extraLines) {
    }

    default public void sessionNegotiationOptionsCreated(Session session2, Map<KexProposalOption, String> proposal) {
    }

    default public void sessionNegotiationStart(Session session2, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal) {
    }

    default public void sessionNegotiationEnd(Session session2, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
    }

    default public void sessionEvent(Session session2, Event event) {
    }

    default public void sessionException(Session session2, Throwable t2) {
    }

    default public void sessionDisconnect(Session session2, int reason, String msg, String language, boolean initiator) {
    }

    default public void sessionClosed(Session session2) {
    }

    public static <L extends SessionListener> L validateListener(L listener) {
        return SshdEventListener.validateListener(listener, SessionListener.class.getSimpleName());
    }

    public static enum Event {
        KeyEstablished,
        Authenticated,
        KexCompleted;

    }
}

