/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSessionIoHandler
extends AbstractLoggingBean
implements IoHandler {
    protected AbstractSessionIoHandler() {
    }

    @Override
    public void sessionCreated(IoSession ioSession) throws Exception {
        ValidateUtils.checkNotNull(this.createSession(ioSession), "No session created for %s", (Object)ioSession);
    }

    @Override
    public void sessionClosed(IoSession ioSession) throws Exception {
        AbstractSession session2 = AbstractSession.getSession(ioSession);
        session2.close(true);
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        AbstractSession session2 = AbstractSession.getSession(ioSession, true);
        if (session2 == null) {
            throw new MissingAttachedSessionException("No session available to signal caught exception=" + cause.getClass().getSimpleName(), cause);
        }
        session2.exceptionCaught(cause);
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable message) throws Exception {
        AbstractSession session2 = AbstractSession.getSession(ioSession);
        try {
            session2.messageReceived(message);
        }
        catch (Error e2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("messageReceived({}) failed {} to handle message: {}", ioSession, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
            throw new RuntimeSshException(e2);
        }
    }

    protected abstract AbstractSession createSession(IoSession var1) throws Exception;
}

