/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Objects;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class CurrentService {
    protected final Session session;
    private String currentName;
    private Service currentService;

    protected CurrentService(Session session2) {
        this.session = Objects.requireNonNull(session2, "No session given");
    }

    public synchronized String getName() {
        return this.currentName;
    }

    public synchronized Service getService() {
        return this.currentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Service service, String name, boolean start2) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No service name specified");
        Objects.requireNonNull(service, "No service specified");
        CurrentService currentService = this;
        synchronized (currentService) {
            this.currentName = name;
            this.currentService = service;
        }
        if (start2) {
            service.start();
        }
    }

    public void start() {
        Service current = this.getService();
        ValidateUtils.checkState(current != null, "No current SSH service; cannot start");
        current.start();
    }

    public boolean process(int cmd, Buffer buffer) throws Exception {
        Service current = this.getService();
        if (current != null) {
            current.process(cmd, buffer);
            return true;
        }
        return false;
    }
}

