/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.List;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ReservedSessionMessagesHandlerAdapter
extends AbstractLoggingBean
implements ReservedSessionMessagesHandler {
    public static final ReservedSessionMessagesHandlerAdapter DEFAULT = new ReservedSessionMessagesHandlerAdapter();

    @Override
    public IoWriteFuture sendIdentification(Session session2, String version2, List<String> extraLines) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}) version={} linesCount={}", session2, version2, GenericUtils.size(extraLines));
        }
        if (this.log.isTraceEnabled() && GenericUtils.isNotEmpty(extraLines)) {
            for (String line : extraLines) {
                this.log.trace("sendIdentification({}) {}", (Object)session2, (Object)line);
            }
        }
        return null;
    }

    @Override
    public void handleIgnoreMessage(Session session2, Buffer buffer) throws Exception {
        this.handleIgnoreMessage(session2, buffer.getBytes(), buffer);
    }

    public void handleIgnoreMessage(Session session2, byte[] data2, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleIgnoreMessage({}) SSH_MSG_IGNORE", (Object)session2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleIgnoreMessage({}) data: {}", (Object)session2, (Object)BufferUtils.toHex(data2));
        }
    }

    @Override
    public void handleDebugMessage(Session session2, Buffer buffer) throws Exception {
        this.handleDebugMessage(session2, buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer);
    }

    public void handleDebugMessage(Session session2, boolean display, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDebugMessage({}) SSH_MSG_DEBUG (display={}) [lang={}] '{}'", session2, display, lang, msg);
        }
    }

    @Override
    public boolean handleUnimplementedMessage(Session session2, int cmd, Buffer buffer) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            if (cmd == 3) {
                long seqNo = buffer.getUInt();
                this.log.debug("handleUnimplementedMessage({}) SSH_MSG_UNIMPLEMENTED - seqNo={}", (Object)session2, (Object)seqNo);
            } else {
                this.log.debug("handleUnimplementedMessage({}): {}", (Object)session2, (Object)SshConstants.getCommandMessageName(cmd));
            }
        }
        return false;
    }
}

