/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SessionTimeoutListener
extends AbstractLoggingBean
implements SessionListener,
Runnable {
    protected final Set<SessionHelper> sessions = new CopyOnWriteArraySet<SessionHelper>();

    @Override
    public void sessionCreated(Session session2) {
        if (session2 instanceof SessionHelper && (GenericUtils.isPositive(session2.getAuthTimeout()) || GenericUtils.isPositive(session2.getIdleTimeout()))) {
            this.sessions.add((SessionHelper)session2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionCreated({}) tracking", (Object)session2);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionCreated({}) not tracked", (Object)session2);
        }
    }

    @Override
    public void sessionException(Session session2, Throwable t2) {
        this.debug("sessionException({}) {}: {}", session2, t2.getClass().getSimpleName(), t2.getMessage(), t2);
        this.sessionClosed(session2);
    }

    @Override
    public void sessionClosed(Session s2) {
        if (this.sessions.remove(s2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) un-tracked", (Object)s2);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionClosed({}) not tracked", (Object)s2);
        }
    }

    @Override
    public void run() {
        for (SessionHelper session2 : this.sessions) {
            try {
                session2.checkForTimeouts();
            }
            catch (Exception e2) {
                this.warn("run({}) {} while checking timeouts: {}", session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
        }
    }
}

