/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.time.Duration;

public class TimeoutIndicator {
    public static final TimeoutIndicator NONE = new TimeoutIndicator(TimeoutStatus.NoTimeout, Duration.ZERO, Duration.ZERO);
    private final TimeoutStatus status;
    private final Duration thresholdValue;
    private final Duration expiredValue;

    public TimeoutIndicator(TimeoutStatus status2, Duration thresholdValue, Duration expiredValue) {
        this.status = status2;
        this.thresholdValue = thresholdValue;
        this.expiredValue = expiredValue;
    }

    public TimeoutStatus getStatus() {
        return this.status;
    }

    public Duration getThresholdValue() {
        return this.thresholdValue;
    }

    public Duration getExpiredValue() {
        return this.expiredValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[status=" + (Object)((Object)this.getStatus()) + ", threshold=" + TimeoutIndicator.toDisplayDurationValue(this.getThresholdValue()) + ", expired=" + TimeoutIndicator.toDisplayDurationValue(this.getExpiredValue()) + "]";
    }

    public static String toDisplayDurationValue(Duration d2) {
        return d2 == null ? null : Long.toString(d2.toMillis());
    }

    public static enum TimeoutStatus {
        NoTimeout,
        AuthTimeout,
        IdleTimeout;

    }
}

