/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Map;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.der.DERWriter;

public class SignatureDSA
extends AbstractSignature {
    public static final String DEFAULT_ALGORITHM = "SHA1withDSA";
    public static final int DSA_SIGNATURE_LENGTH = 40;
    public static final int MAX_SIGNATURE_VALUE_LENGTH = 20;

    public SignatureDSA() {
        this(DEFAULT_ALGORITHM);
    }

    protected SignatureDSA(String algorithm) {
        super(algorithm);
    }

    @Override
    public byte[] sign(SessionContext session2) throws Exception {
        byte[] sig = super.sign(session2);
        try (DERParser parser = new DERParser(sig);){
            int type2 = parser.read();
            if (type2 != 48) {
                throw new StreamCorruptedException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(type2));
            }
            int remainLen = parser.readLength();
            if (remainLen < 6) {
                throw new StreamCorruptedException("Invalid signature format - not enough encoded data length: " + remainLen);
            }
            BigInteger r = parser.readBigInteger();
            BigInteger s2 = parser.readBigInteger();
            byte[] result2 = new byte[40];
            SignatureDSA.putBigInteger(r, result2, 0);
            SignatureDSA.putBigInteger(s2, result2, 20);
            byte[] byArray = result2;
            return byArray;
        }
    }

    public static void putBigInteger(BigInteger value2, byte[] result2, int offset) {
        byte[] data2 = value2.toByteArray();
        boolean maxExceeded = data2.length > 20;
        int dstOffset = maxExceeded ? 0 : 20 - data2.length;
        System.arraycopy(data2, maxExceeded ? 1 : 0, result2, offset + dstOffset, Math.min(20, data2.length));
    }

    @Override
    public boolean verify(SessionContext session2, byte[] sig) throws Exception {
        byte[] encoded;
        byte[] sEncoding;
        byte[] rEncoding;
        Map.Entry<String, byte[]> encoding;
        int sigLen = NumberUtils.length(sig);
        byte[] data2 = sig;
        if (sigLen != 40 && (encoding = this.extractEncodedSignature(sig, "ssh-dss"::equalsIgnoreCase)) != null) {
            String keyType = encoding.getKey();
            ValidateUtils.checkTrue("ssh-dss".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data2 = encoding.getValue();
            sigLen = NumberUtils.length(data2);
        }
        if (sigLen != 40) {
            throw new SignatureException("Bad signature length (" + sigLen + " instead of " + 40 + ") for " + BufferUtils.toHex(':', data2));
        }
        try (DERWriter w = new DERWriter(24);){
            w.writeBigInteger(data2, 0, 20);
            rEncoding = w.toByteArray();
        }
        try (DERWriter w = new DERWriter(24);){
            w.writeBigInteger(data2, 20, 20);
            sEncoding = w.toByteArray();
        }
        int length = rEncoding.length + sEncoding.length;
        try (DERWriter w = new DERWriter(1 + length + 4);){
            w.write(48);
            w.writeLength(length);
            w.write(rEncoding);
            w.write(sEncoding);
            encoded = w.toByteArray();
        }
        return this.doVerify(encoded);
    }
}

