/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public final class NumberUtils {
    public static final List<Class<?>> NUMERIC_PRIMITIVE_CLASSES = GenericUtils.unmodifiableList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    private NumberUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static int getNextPowerOf2(int value2) {
        if (value2 < 0) {
            throw new IllegalArgumentException("Negative value N/A: " + value2);
        }
        int j2 = 1;
        while (j2 < value2) {
            if ((j2 <<= 1) > 0) continue;
            return value2;
        }
        return j2;
    }

    public static int hashCode(long ... values2) {
        return Arrays.hashCode(values2);
    }

    public static int hashCode(int ... values2) {
        return Arrays.hashCode(values2);
    }

    public static int hashCode(byte ... values2) {
        return Arrays.hashCode(values2);
    }

    public static int hashCode(byte[] a2, int offset, int len2) {
        if (len2 == 0) {
            return 0;
        }
        int result2 = 1;
        int pos = offset;
        for (int count2 = 0; count2 < len2; ++count2) {
            byte element = a2[pos];
            result2 = 31 * result2 + element;
            ++pos;
        }
        return result2;
    }

    public static int diffOffset(byte[] a1, int startPos1, byte[] a2, int startPos2, int len2) {
        int pos1 = startPos1;
        int pos2 = startPos2;
        for (int count2 = 0; count2 < len2; ++count2) {
            byte v1 = a1[pos1];
            byte v2 = a2[pos2];
            if (v1 != v2) {
                return count2;
            }
            ++pos1;
            ++pos2;
        }
        return -1;
    }

    public static boolean isNumericClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return NUMERIC_PRIMITIVE_CLASSES.indexOf(clazz) >= 0;
    }

    public static Integer toInteger(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public static String join(CharSequence separator, long ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (long v : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, long ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (long v : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, boolean unsigned, byte ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (int n : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(char separator, boolean unsigned, byte ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (int n : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, int ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (int v : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, int ... values2) {
        if (NumberUtils.isEmpty(values2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values2.length * 8);
        for (int v : values2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static byte[] emptyIfNull(byte[] a2) {
        return a2 == null ? GenericUtils.EMPTY_BYTE_ARRAY : a2;
    }

    public static boolean isEmpty(byte[] a2) {
        return NumberUtils.length(a2) <= 0;
    }

    public static boolean isEmpty(int[] a2) {
        return NumberUtils.length(a2) <= 0;
    }

    public static boolean isEmpty(long[] a2) {
        return NumberUtils.length(a2) <= 0;
    }

    public static int length(byte ... a2) {
        return a2 == null ? 0 : a2.length;
    }

    public static int length(int ... a2) {
        return a2 == null ? 0 : a2.length;
    }

    public static int length(long ... a2) {
        return a2 == null ? 0 : a2.length;
    }

    public static List<Integer> asList(int ... values2) {
        int len2 = NumberUtils.length(values2);
        if (len2 <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> l = new ArrayList<Integer>(len2);
        for (int v : values2) {
            l.add(v);
        }
        return l;
    }

    public static boolean isIntegerNumber(CharSequence cs) {
        if (GenericUtils.isEmpty(cs)) {
            return false;
        }
        int len2 = cs.length();
        for (int index = 0; index < len2; ++index) {
            char c2 = cs.charAt(index);
            if (c2 >= '0' && c2 <= '9' || (c2 == '+' || c2 == '-') && index == 0) continue;
            return false;
        }
        return true;
    }
}

